context("mixnorm")

test_that("rmixnorm with weird inputs", {
  expect_error(rmixnorm(numeric(0)))
  expect_error(rmixnorm(-1))
  expect_error(rmixnorm(Inf))
  expect_error(rmixnorm(NaN))
  expect_error(rmixnorm(10, mean=-1, sd=-1))
  expect_error(rmixnorm(10, mean=c(1,2), sd=c(3,-1)))
  expect_error(rmixnorm(10, mean=Inf, sd=Inf))
  expect_error(rmixnorm(10, mean=1, sd=c(2,3)))
  expect_error(rmixnorm(10, mean=c(1,2), prob=c(-0.1,1.1)))
  expect_error(rmixnorm(10, mean=c(1,2), prob=c(0.1,0.3,1)))
  expect_error(rmixnorm(10, type='hello'))
})

test_that("dmixnorm with weird inputs", {
  expect_error(dmixnorm(numeric(0)))
  expect_error(dmixnorm(NA))
  expect_error(dmixnorm(Inf))
  expect_error(dmixnorm(NaN))
  expect_error(dmixnorm(10, mean=-1, sd=-1))
  expect_error(dmixnorm(10, mean=c(1,2), sd=c(3,-1)))
  expect_error(dmixnorm(10, mean=Inf, sd=Inf))
  expect_error(dmixnorm(10, mean=1, sd=c(2,3)))
  expect_error(dmixnorm(10, mean=c(1,2), prob=c(-0.1,1.1)))
  expect_error(dmixnorm(10, mean=c(1,2), prob=c(0.1,0.3,1)))
  expect_error(dmixnorm(10, type='hello'))
})

test_that("pmixnorm with weird inputs", {
  expect_error(pmixnorm(numeric(0)))
  expect_error(pmixnorm(NA))
  expect_error(pmixnorm(Inf))
  expect_error(pmixnorm(NaN))
  expect_error(pmixnorm(10, mean=-1, sd=-1))
  expect_error(pmixnorm(10, mean=c(1,2), sd=c(3,-1)))
  expect_error(pmixnorm(10, mean=Inf, sd=Inf))
  expect_error(pmixnorm(10, mean=1, sd=c(2,3)))
  expect_error(pmixnorm(10, mean=c(1,2), prob=c(-0.1,1.1)))
  expect_error(pmixnorm(10, mean=c(1,2), prob=c(0.1,0.3,1)))
  expect_error(pmixnorm(10, type='hello'))
})