% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Beta.R, R/02_Binom.R,
%   R/02_Dirichlet.R, R/02_Exp.R, R/02_Gammad.R, R/02_MGamma.R, R/02_Norm.R,
%   R/02_Pois.R
\name{mle}
\alias{mle}
\alias{mle,ANY,character-method}
\alias{mle,numeric,Beta-method}
\alias{mle,numeric,Binom-method}
\alias{mle,matrix,Dirichlet-method}
\alias{mle,numeric,Exp-method}
\alias{mle,numeric,Gammad-method}
\alias{mle,matrix,MGamma-method}
\alias{mle,numeric,Norm-method}
\alias{mle,numeric,Pois-method}
\title{Maximum Likelihood Estimation}
\usage{
mle(x, distr, ...)

\S4method{mle}{ANY,character}(x, distr, ...)

\S4method{mle}{numeric,Beta}(x, distr, par0 = "same", method = "L-BFGS-B", lower = 1e-05, upper = Inf)

\S4method{mle}{numeric,Binom}(x, distr)

\S4method{mle}{matrix,Dirichlet}(x, distr, par0 = "same", method = "L-BFGS-B", lower = 1e-05, upper = Inf)

\S4method{mle}{numeric,Exp}(x, distr)

\S4method{mle}{numeric,Gammad}(x, distr, par0 = "same", method = "L-BFGS-B", lower = 1e-05, upper = Inf)

\S4method{mle}{matrix,MGamma}(x, distr, par0 = "same", method = "L-BFGS-B", lower = 1e-05, upper = Inf)

\S4method{mle}{numeric,Norm}(x, distr)

\S4method{mle}{numeric,Pois}(x, distr)
}
\arguments{
\item{x}{numeric. A sample under estimation.}

\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{...}{extra arguments.}

\item{par0}{function. The estimator to use for initialization of the
likelihood maximization algorithm.}

\item{method, lower, upper}{arguments passed to optim.}
}
\value{
numeric. The estimator produced by the sample.
}
\description{
Calculates the MLE under the assumption the sample observations are
independent and identically distributed (iid) according to a
specified family of distributions.
}
\examples{
# -------------------------------------------
# Beta Distribution Example
# -------------------------------------------

# Simulation
set.seed(1)
shape1 <- 1
shape2 <- 2
x <- rbeta(100, shape1, shape2)

library(distr)
D <- Beta(shape1, shape2)

# Likelihood - The ll Functions

llbeta(x, shape1, shape2)
ll(x, c(shape1, shape2), D)
ll(x, c(shape1, shape2), "beta")

# Point Estimation - The e Functions

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(x, D)
me(x, D)
same(x, D)

estim(x, D, type = "mle")

# Asymptotic Variance - The v Functions

vbeta(shape1, shape2, type = "mle")
vbeta(shape1, shape2, type = "me")
vbeta(shape1, shape2, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

avar(D, type = "mle")
}
\references{
Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.

Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.

Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.

Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.

Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
\seealso{
\link{estim}, \link{me}, \link{same}
}
