% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_glance.R
\name{estimatr_glancers}
\alias{estimatr_glancers}
\alias{glance.lm_robust}
\alias{glance.lh_robust}
\alias{glance.iv_robust}
\alias{glance.difference_in_means}
\alias{glance.horvitz_thompson}
\title{Glance at an estimatr object}
\usage{
\method{glance}{lm_robust}(x, ...)

\method{glance}{lh_robust}(x, ...)

\method{glance}{iv_robust}(x, ...)

\method{glance}{difference_in_means}(x, ...)

\method{glance}{horvitz_thompson}(x, ...)
}
\arguments{
\item{x}{An object returned by one of the estimators}

\item{...}{extra arguments (not used)}
}
\value{
For \code{glance.lm_robust}, a data.frame with columns:
\item{r.squared}{the \eqn{R^2},
\deqn{R^2 = 1 - Sum(e[i]^2) / Sum((y[i] - y^*)^2),} where \eqn{y^*}
is the mean of \eqn{y[i]} if there is an intercept and zero otherwise,
and \eqn{e[i]} is the ith residual.}
\item{adj.r.squared}{the \eqn{R^2} but penalized for having more parameters, \code{rank}}
\item{se_type}{the standard error type specified by the user}
\item{statistic}{the value of the F-statistic}
\item{p.value}{p-value from the F test}
\item{df.residual}{residual degrees of freedom}
\item{N}{the number of observations used}

For \code{glance.lh_robust}, we glance the \code{lm_robust} component only. You can access the linear hypotheses as a data.frame directy from the \code{lh} component of the \code{lh_robust} object

For \code{glance.iv_robust}, a data.frame with columns:
\item{r.squared}{The \eqn{R^2} of the second stage regression}
\item{adj.r.squared}{The \eqn{R^2} but penalized for having more parameters, \code{rank}}
\item{df.residual}{residual degrees of freedom}
\item{N}{the number of observations used}
\item{se_type}{the standard error type specified by the user}
\item{statistic}{the value of the F-statistic}
\item{p.value}{p-value from the F test}
\item{statistic.weakinst}{the value of the first stage F-statistic, useful for the weak instruments test; only reported if there is only one endogenous variable}
\item{p.value.weakinst}{p-value from the first-stage F test, a test of weak instruments; only reported if there is only one endogenous variable}
\item{statistic.endogeneity}{the value of the F-statistic for the test of endogeneity; often called the Wu-Hausman statistic, with robust standard errors, we employ the regression based test}
\item{p.value.endogeneity}{p-value from the F-test for endogeneity}
\item{statistic.overid}{the value of the chi-squared statistic for the test of instrument correlation with the error term; only reported with overidentification}
\item{p.value.overid}{p-value from the chi-squared test; only reported with overidentification}

For \code{glance.difference_in_means}, a data.frame with columns:
\item{design}{the design used, and therefore the estimator used}
\item{df}{the degrees of freedom}
\item{N}{the number of observations used}
\item{N_blocks}{the number of blocks, if used}
\item{N_clusters}{the number of clusters, if used}
\item{condition2}{the second, "treatment", condition}
\item{condition1}{the first, "control", condition}

For \code{glance.horvitz_thompson}, a data.frame with columns:
\item{N}{the number of observations used}
\item{se_type}{the type of standard error estimator used}
\item{condition2}{the second, "treatment", condition}
\item{condition1}{the first, "control", condition}
}
\description{
Glance at an estimatr object
}
\seealso{
\code{\link[generics:glance]{generics::glance()}}, \code{\link[estimatr:lm_robust]{estimatr::lm_robust()}}, \code{\link[estimatr:lm_lin]{estimatr::lm_lin()}}, \code{\link[estimatr:iv_robust]{estimatr::iv_robust()}}, \code{\link[estimatr:difference_in_means]{estimatr::difference_in_means()}}, \code{\link[estimatr:horvitz_thompson]{estimatr::horvitz_thompson()}}
}
\concept{estimatr glancers}
