% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.qe.fit.R
\name{plot.qe.fit}
\alias{plot.qe.fit}
\title{Plot method for objects of class "qe.fit"}
\usage{
\method{plot}{qe.fit}(x, distributions = c("normal", "log-normal",
  "gamma", "weibull"), points = TRUE, limits, col, legend = TRUE,
  xlab = "x", ylab = "F(x)", ylim = c(0, 1), cex.points = 0.85,
  pch.points = 16, length.out = 10000, ...)
}
\arguments{
\item{x}{object of class "qe.fit".}

\item{distributions}{character vector specifying the names of distributions to be plotted. The options are: \code{"normal"}, \code{"log-normal"}, \code{"gamma"}, \code{"weibull"}, and \code{"beta"}. By default, the normal, log-normal, gamma, and Weibull distributions are plotted. If one of the specified distributions was not successfully fit (e.g., \code{\link{qe.fit}} failed to converge for the given distribution), the distribution will not be included in the plot.}

\item{points}{logical scalar indicating whether to plot the observed summary data (i.e., the sample quantiles reported by the study). The default is \code{TRUE}.}

\item{limits}{numeric vector of length 2 specifying the bounds of the interval in which to evaluate of the cumulative distribution functions.  See 'Details'.}

\item{col}{character vector specifying the colors to use for the distributions. The kth element in this vector corresponds to the color to be used for the kth element in the \code{distribution} argument.}

\item{legend}{logical scalar indicating whether to plot a legend. The default is \code{TRUE}.}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}

\item{ylim}{y-axis limits.}

\item{cex.points}{The magnification to be used for the plotted observed summary data (i.e., for the \code{points} argument).}

\item{pch.points}{either an integer specifying a symbol or a single character to be used as the default in plotting the observed summary data (i.e., for the \code{points} argument). See \code{\link[graphics]{points}} for possible values and their interpretation.}

\item{length.out}{numeric scalar specifying the number of points to be used for evaluating each of the cumulative distribution functions.}

\item{...}{other graphical parameters (see \code{\link[graphics]{par}}).}
}
\description{
This function plots the cumulative distribution functions of the fitted distributions along with the summary data reported by the study (i.e., the S1, S2, or S3 data).
}
\details{
Users may need to use the \code{limits} argument so that a sensible interval is used for plotting. By default, the limits of the interval are the sample minimum and maximum values in scenarios S1 and S3, which is often adequate. In scenario S2, the limits are based on the quantiles of the distribution with the best fit (i.e., the fitted distribution obtaining the smallest distance between observed and distribution quantiles). If the normal distribution is the best fit, the limits of the interval are the 1/n th quantile and 1-1/n th quantile of the fitted normal distribution. If any of the other distributions are selected, the 1/n th quantile and 0.90 quantile are used as the limits of the interval. Depending on the skewness of the data, users may need to adjust the upper limit.
}
\examples{
## Example 1
## Generate S3 summary data
set.seed(1)
n <- 100
x <- stats::rlnorm(n, 2.5, 1)
quants <- stats::quantile(x, probs = c(0, 0.25, 0.5, 0.75, 1))

## Fit distributions
res <- qe.fit(min.val = quants[1], q1.val = quants[2], med.val = quants[3],
       q3.val = quants[4], max.val = quants[5], n = n)
plot(res)

## Example 2
res <- qe.fit(q1.val = 1, med.val = 2, q3.val = 3, n = 100)
plot(res, limits = c(0, 5))

}
\seealso{
\code{\link{qe.fit}}
}
