% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_tests.R
\name{brown_warner_1985}
\alias{brown_warner_1985}
\title{Brown and Warner parametric test (1985).}
\usage{
brown_warner_1985(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mean}: an average abnormal return
    \item \code{bw_1985_stat}: a Brown and Warner (1985) test statistic
    \item \code{bw_1985_signif}: a significance of the statistic
}
}
\description{
An event study parametric test described in Brown and Warner 1985.
}
\details{
Performs a parametric test for event study, which is described in Brown and
Warner 1985, which is a traditional event study approach. This test does not
require cross-sectional independence but is non-robust to an event-induced
variance. The test examines the hypothesis whether the theoretical
cross-sectional expected value for a given day is equal to zero. The standard
 deviation in statistics is estimated as the cross-sectional standard
deviation of companies' means, estimated on the estimation period. It
calculates statistics even if event window and estimation period are
overlapped (intersect). The critical values are Student's t-distributed (no
approximation in limit). The significance levels of \eqn{\alpha} are 0.1,
 0.05, and 0.01 (marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^GSPC",
                                      start = as.Date("2019-04-01"),
                                      end = as.Date("2020-04-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("AMZN", "ZM", "UBER", "NFLX", "SHOP", "FB", "UPWK")
get_prices_from_tickers(tickers,
                        start = as.Date("2019-04-01"),
                        end = as.Date("2020-04-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2019-04-01"),
                       estimation_end = as.Date("2020-03-13")) \%>\%
    brown_warner_1985(event_start = as.Date("2020-03-16"),
                      event_end = as.Date("2020-03-20"))
}
## The result of the code above is equivalent to:
data(securities_returns)
brown_warner_1985(list_of_returns = securities_returns,
                  event_start = as.Date("2020-03-16"),
                  event_end = as.Date("2020-03-20"))

}
\references{
Brown S.J., Warner J.B. \emph{Using Daily Stock Returns, The Case
 of Event Studies}. Journal of Financial Economics, 14:3-31, 1985.
}
\seealso{
\code{\link{parametric_tests}}, \code{\link{brown_warner_1980}},
\code{\link{t_test}}, \code{\link{patell}}, \code{\link{boehmer}}, and
\code{\link{lamb}}.
}
