% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{nonparametric_tests}
\alias{nonparametric_tests}
\title{Returns the result of given event study nonparametric tests.}
\usage{
nonparametric_tests(list_of_returns, event_start, event_end, all = TRUE, tests)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}

\item{all}{a logical vector of length one indicating whether all tests should
be performed. The default value is \code{TRUE}.}

\item{tests}{a list of tests' functions among \code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{corrado_sign_test}},
\code{\link{rank_test}}, \code{\link{modified_rank_test}}, and
\code{\link{wilcoxon_test}}.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item Various tests' statistics and significance
}
}
\description{
Performs main nonparametric tests for each date in the event window and
returns a data frame of their statistics and significance.
}
\details{
\code{nonparametric_tests} performs given tests among \code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{corrado_sign_test}},
\code{\link{rank_test}}, \code{\link{modified_rank_test}},
\code{\link{wilcoxon_test}}, and merge result to a single data frame. If
\code{all = TRUE} (the default value), the function ignores the value of
\code{tests}.
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^GSPC",
                                      start = as.Date("2019-04-01"),
                                      end = as.Date("2020-04-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("AMZN", "ZM", "UBER", "NFLX", "SHOP", "FB", "UPWK")
nparam <- get_prices_from_tickers(tickers,
                                  start = as.Date("2019-04-01"),
                                  end = as.Date("2020-04-01"),
                                  quote = "Close",
                                  retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2019-04-01"),
                       estimation_end = as.Date("2020-03-13")) \%>\%
    nonparametric_tests(event_start = as.Date("2020-03-16"),
                        event_end = as.Date("2020-03-20"))
}
## The result of the code above is equivalent to:
data(securities_returns)
nparam <- nonparametric_tests(list_of_returns = securities_returns,
                              event_start = as.Date("2020-03-16"),
                              event_end = as.Date("2020-03-20"))

}
\references{
\itemize{
\item Corrado C.J., Zivney T.L. \emph{The Specification and Power of
the Sign Test in Event Study Hypothesis Tests Using Daily Stock Returns}.
Journal of Financial and Quantitative Analysis, 27(3):465-478, 1992.
\item McConnell J.J., Muscarella C.J. \emph{Capital expenditure plans and
firm value} Journal of Financial Economics, 14:399-422, 1985.
\item Boehmer E., Musumeci J., Poulsen A.B. \emph{Event-study methodology
under conditions of event-induced variance}. Journal of Financial Economics,
30(2):253-272, 1991.
\item Cowan A.R. \emph{Nonparametric Event Study Tests}. Review of
Quantitative Finance and Accounting, 2:343-358, 1992.
\item Corrado C.J. \emph{A Nonparametric Test for Abnormal Security-Price
Performance in Event Studies}. Journal of Financial Economics 23:385-395,
1989.
\item Campbell C.J., Wasley C.E. \emph{Measuring Security Price Performance
Using Daily NASDAQ Returns}. Journal of Financial Economics 33:73-92, 1993.
\item Savickas R. \emph{Event-Induced Volatility and Tests for Abnormal
Performance}. The Journal of Financial Research, 26(2):156-178, 2003.
\item Kolari J.W., Pynnonen S. \emph{Event Study Testing with Cross-sectional
Correlation of Abnormal Returns}. The Review of Financial Studies,
23(11):3996-4025, 2010.
\item Wilcoxon F. \emph{Individual Comparisons by Ranking Methods}.
Biometrics Bulletin 1(6):80-83, 1945.
\item Lehmann E.L, \emph{Nonparametrics: Statistical Methods Based on Ranks}.
San Francisco: Holden-Day, 1975.
\item Hollander M., Wolfe D.A. \emph{Nonparametric Statistical Methods}.
New York: John Wiley & Sons, 1973.
}
}
\seealso{
\code{\link{sign_test}}, \code{\link{generalized_sign_test}},
\code{\link{corrado_sign_test}}, \code{\link{rank_test}},
\code{\link{modified_rank_test}}, and \code{\link{wilcoxon_test}}.
}
