% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{modified_rank_test}
\alias{modified_rank_test}
\title{An event study modified rank test.}
\usage{
modified_rank_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mrank_stat}: a modified rank test statistic
    \item \code{mrank_signif}: a significance of the statistic
}
}
\description{
The test is the modification of the original rank test, proposed by Corrado
1989. This test is adapted to missing values in abnormal returns.
}
\details{
In addition to the original rank test, the procedure divides corresponding
ranks by the number of nonmissing returns plus one for each security. This
leads to order statistics with uniform distribution. In limit overall
statistics under a null hypothesis is approximately normally distributed. For
this test the estimation period and the event period must not overlap,
otherwise an error will be thrown. The test is well-specified for the case,
when cross-sectional abnormal returns are not symmetric. The test is stable
to variance increase during the event window. This test is more sensitive to
extreme values than the sign test. The significance levels of \eqn{\alpha}
are 0.1, 0.05, and 0.01 (marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^N100",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    modified_rank_test(event_start = as.Date("2001-09-11"),
                       event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
modified_rank_test(list_of_returns = securities_returns,
                   event_start =  as.Date("2001-09-11"),
                   event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item Corrado C.J., Zivney T.L. \emph{The Specification and Power of
the Sign Test in Event Study Hypothesis Tests Using Daily Stock Returns}.
Journal of Financial and Quantitative Analysis, 27(3):465-478, 1992.
\item Kolari J.W., Pynnonen S. \emph{Event Study Testing with Cross-sectional
Correlation of Abnormal Returns}. The Review of Financial Studies,
23(11):3996-4025, 2010.
}
}
\seealso{
\code{\link{nonparametric_tests}},\code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{corrado_sign_test}},
\code{\link{rank_test}}, and \code{\link{wilcoxon_test}}.
}
