% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_es_plot.R
\name{qtile_es}
\alias{qtile_es}
\title{Compute effect sizes by quantile bins}
\usage{
qtile_es(formula, data, ref_group = NULL, qtiles = seq(0, 1, 0.33))
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note the
grouping variable must only include only two groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional character vector (of length 1) naming the
reference group to be plotted on the x-axis. Defaults to the highest
scoring group.}

\item{qtiles}{The percentiles to split the data by and calculate effect 
sizes. Essentially, this is the binning argument. Defaults to 
\code{seq(0, 1, .33)}, which splits the distribution into thirds (lower,
middle, upper). Any sequence is valid, but it is recommended the bins be
even. For example \code{seq(0, 1, .1)} would split the distributions into
deciles.}
}
\description{
Returns a data frame with the estimated effect size by the provided 
percentiles. Currently, the effect size is equivalent to Cohen's d, but 
future development will allow this to vary.
}
\examples{

# Compute effect sizes (Cohen's d) by default quantiles
qtile_es(reading ~ condition, star)

# Compute Cohen's d by quintile
qtile_es(reading ~ condition, 
		star, 
		qtiles = seq(0, 1, .2))

# Report effect sizes only relative to regular-sized classrooms
qtile_es(reading ~ condition, 
		star, 
		ref_group = "reg",
		qtiles = seq(0, 1, .2))
}
