% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emfx.R
\name{emfx}
\alias{emfx}
\title{Post-estimation treatment effects for an ETWFE regressions.}
\usage{
emfx(
  object,
  type = c("simple", "group", "calendar", "event"),
  post_only = TRUE,
  ...
)
}
\arguments{
\item{object}{An `etwfe` model object.}

\item{type}{Character. The desired type of post-estimation aggregation.}

\item{post_only}{Logical. Only keep post-treatment effects. All
pre-treatment effects will be zero as a mechanical result of ETWFE's 
estimation setup, so the default is to drop these nuisance rows from
the dataset. But you may want to keep them for presentation reasons
(e.g., plotting an event-study); though be warned that this is 
strictly performative. This argument will only be evaluated if
`type = "event"`.}

\item{...}{Additional arguments passed to 
[`marginaleffects::marginaleffects`].}
}
\value{
A marginaleffects object.
}
\description{
Post-estimation treatment effects for an ETWFE regressions.
}
\examples{
# We’ll use the mpdta dataset from the did package (which you’ll need to 
# install separately).

# install.packages("did")
data("mpdta", package = "did")

# Run the estimation
mod = etwfe(
    fml  = lemp ~ lpop, # outcome ~ controls
    tvar = year,        # time variable
    gvar = first.treat, # group variable
    data = mpdta,       # dataset
    vcov = ~countyreal  # vcov adjustment (here: clustered by county)
    )
mod

# We can recover a variety of treatment effects of interest with the 
# complementary emfx() function. For example:
emfx(mod, type = "event")

}
\seealso{
[marginaleffects::marginaleffects()]
}
