% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_search.R
\name{find}
\alias{find}
\title{Search Eurostat datasets and see the result as text}
\usage{
find(...)
}
\arguments{
\item{...}{A series of unquoted words to be searched either in Eurostat dataset
codes or in dataset full names. All words not preceded by minus (-) will be linked
with logical AND; all words preceded by a minus entail exclusion (logical NOT),
 a bit like in Google search. It is possible to search also with
phrases that include spaces -- in such a case the phrases should be
quoted. Partial word/phrase match is applied. See the examples below.}
}
\value{
\itemize{
  \item Side effect (via \code{print}) -- a text report file opened via \code{\link{file.show}}.
  \item Value -- a list with:
  \itemize{
    \item criteria -- a string, search criteria,
    \item time -- the time of the query,
    \item df -- a data.frame, imported via \code{\link[eurodata]{importDataList}} and
    filtered based on the conditions specified in \code{...},
    \item report -- a string, with the text report.
  }
}
}
\description{
A tool for a quick ad-hoc search.
}
\examples{
\dontrun{
find(bop, its)
find(bop,-ybk,its)
find(nama_)
find(nama,10,64)
find('economic indic')
}
}
