% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_dic.R
\name{get_eurostat_dic}
\alias{getEurostatDictionary}
\alias{get_eurostat_dic}
\title{Download a Eurostat dictionary}
\usage{
get_eurostat_dic(dictname, lang = "en")

getEurostatDictionary(dictname)
}
\arguments{
\item{dictname}{A character, dictionary for given variable name 
will be downloaded.}

\item{lang}{A character, code for language. Available are "en" (default), 
"fr" and "de".}
}
\value{
A data.frame with two columns, first with code names and 
         second with full names.
}
\description{
Download a Eurostat dictionary. Download a dictionary for
             given coded variable from Eurostat (ec.europa.eu/eurostat).
             Dictionaries link codes with human-readable labels.
             To translate codes to labels with \code{\link{label_eurostat}}.
}
\section{Functions}{
\itemize{
\item \code{getEurostatDictionary}: Old deprecated version
}}
\examples{
\dontrun{
	       tmp <- get_eurostat_dic("crop_pro")
	       head(tmp)
	       tmp <- get_eurostat_dic("crop_pro", lang = "fr")
     }
}
\author{
Przemyslaw Biecek and Leo Lahti \email{ropengov-forum@googlegroups.com}
}
\references{
see citation("eurostat").
}
\seealso{
\code{\link{label_eurostat}}, \code{\link{get_eurostat}}, 
         \code{\link{search_eurostat}}.
}
\keyword{database}
\keyword{utilities}

