% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentiate.R
\name{SecondOrderDiffVal}
\alias{SecondOrderDiffVal}
\title{Second-order centered differentiation calculation.}
\usage{
SecondOrderDiffVal(value.p, value.c, value.m, epsilon)
}
\arguments{
\item{value.p}{function value at \code{x+epsilon}.}

\item{value.c}{function value at \code{x}.}

\item{value.m}{function value at \code{x-epsilon}.}

\item{epsilon}{offset value for \code{x}.}
}
\value{
\code{(value.p -2*value.c + value.m) / (2*epsilon)}.
}
\description{
Second-order centered differentiation calculation.
}
