% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevCIboot.R
\name{gevCIboot}
\alias{gevCIboot}
\title{Bootstrapped Standard Errors for Fitted GEV1 (Block Maxima) Models}
\usage{
gevCIboot(z, conf = 0.95, bootnum, resampling = c("in", "ht", "sc"),
  grouping = NULL, ordering = NULL, allowParallel = FALSE, numCores = 1)
}
\arguments{
\item{z}{A class object returned from `gevrFit'.}

\item{conf}{Confidence level. Defaults to 95 percent.}

\item{bootnum}{Number of bootstrap replicates.}

\item{resampling}{Whether to use independent, Heffernan-Tawn, or Spearman-Correlation resampling, respectively.
See details.}

\item{grouping}{Vector specifying grouping of the observations. Typically refers to location or site in environmental applications.}

\item{ordering}{Vector specifying the (temporal) ordering of the observations within each group.}

\item{allowParallel}{Should the bootstrap procedure be run in parallel or not. Defaults to false.}

\item{numCores}{If allowParallel is true, specify the number of cores to use.}
}
\value{
\item{CIs}{Confidence intervals for the GEV parameters.}
\item{effective_bootnum}{Effective number of bootstrap replicates (only those that converged are used).}
\item{replicates}{Matrix of bootstrap replicates.}
}
\description{
Computes bootstrap based standard errors for fitted block maxima models under independence and
two semi-parametric approaches to bootstrap from models with dependence.
}
\details{
Under independence, resampling is entirely parametric -- that is, GEV1 data are generated
directly from the fitted distribution provided for each replicate. The Heffernan-Tawn approach is one
attempt to capture dependence within the resampling process, by preserving the temporal ordering across
groups when generating data. The Spearman-Correlation resampling approach, roughly speaking, generates
multivariate data according to the correlation structure of the original data residuals. Both are
considered semi-parametric approaches. See references and function \code{\link[EnvStats]{simulateMvMatrix}}
in the EnvStats package for details.
}
\examples{
## Not run
# n <- 100
# r <- 1
# x <- rgevr(n, r, loc = 100 + 1:n / 50,  scale = 1 + 1:n / 300, shape = 0)
# covs <- as.data.frame(seq(1, n, 1))
# names(covs) <- c("Trend1")
## Create some unrelated covariates
# covs$Trend2 <- rnorm(n)
# covs$Trend3 <- 30 * runif(n)
# z <- gevrFit(data = x, method = "mle", locvars = covs, locform = ~ Trend1 + Trend2*Trend3,
#              scalevars = covs, scaleform = ~ Trend1)
# gevCIboot(z, bootnum = 100, resampling = "in")
## Now create groupings for this data -- four sites
# grouping <- c(rep("A", n/4), rep("B", n/4), rep("C", n/4), rep("D", n/4))
# ordering <- rep(seq(1, n/4, 1), 4)
# gevCIboot(z, bootnum = 100, resampling = "sc", grouping = grouping, ordering = ordering)
## See vignette for a detailed example with dependent data
}
\references{
Iman, R. L., & Conover, W. J. (1982). A distribution-free approach to inducing rank correlation among
input variables. Communications in Statistics-Simulation and Computation, 11(3), 311-334.

Heffernan, J. E., & Tawn, J. A. (2004). A conditional approach for multivariate extreme values (with
discussion). Journal of the Royal Statistical Society: Series B (Statistical Methodology), 66(3), 497-546.
}

