% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast_to_netcdf.R
\name{rast_to_netcdf}
\alias{rast_to_netcdf}
\title{Function to convert/save a SpatRaster array/Netcdf}
\usage{
rast_to_netcdf(r, file, name, unit = units(r), XY = FALSE, verbose = TRUE)
}
\arguments{
\item{r}{SpatRaster object}

\item{file}{Netcdf file name}

\item{name}{variable name on a Netcdf file}

\item{unit}{unit of the variable (set to NA to don't change unit)}

\item{XY}{set to true if MemoryOrder is XY (only if file is missing)}

\item{verbose}{display additional information}
}
\value{
numerical array
}
\description{
Conversion of SpatRaster to array and optionally save on a Netcdf File.
}
\note{
eva3dm::wrf_rast support 3d SpatRaster, in case of a 4d variable use other approach to save on file.
}
\examples{
folder   <- system.file("extdata",package="eva3dm")
wrf_file <- paste0(folder,"/wrf.day1.o3.nc")

Rast     <- wrf_rast(wrf_file,'o3')
A        <- rast_to_netcdf(Rast)

}
