% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{trim_intermediate_plots}
\alias{trim_intermediate_plots}
\title{Trim away intermediate plots}
\usage{
trim_intermediate_plots(x)
}
\arguments{
\item{x}{An evaluation object produced by \code{\link[=evaluate]{evaluate()}}.}
}
\value{
A modified evaluation object.
}
\description{
Trim off plots that are modified by subsequent lines to only show
the "final" plot.
}
\examples{
ev <- evaluate(c(
  "plot(1:3)",
  "text(1, 1, 'x')",
  "text(1, 1, 'y')"
))

# All intermediate plots are captured
ev
# Only the final plot is shown
trim_intermediate_plots(ev)
}
