% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openfair.R
\name{openfair_tef_tc_diff_plm_sr}
\alias{openfair_tef_tc_diff_plm_sr}
\title{Run an OpenFAIR simulation at the TEF/TC/DIFF/PLM/SR levels}
\usage{
openfair_tef_tc_diff_plm_sr(tef, tc, diff, plm, sr, n = 10^4, verbose = FALSE)
}
\arguments{
\item{tef}{Parameters for TEF simulation.}

\item{tc}{Parameters for TC simulation.}

\item{diff}{Parameters for DIFF simulation.}

\item{plm}{Parameters for PLM simulation.}

\item{sr}{Parameters for SR simulation.}

\item{n}{Number of iterations to run.}

\item{verbose}{Whether to print progress indicators.}
}
\value{
Dataframe of scenario name, threat_event count, loss_event count,
mean TC and DIFF exceedance, and ALE samples.
}
\description{
Run an OpenFAIR model with parameters provided for TEF, TC, DIFF, PLM, and
SR sampling. If there are multiple controls provided for the scenario, the
arithmetic mean (average) is taken across samples for all controls to get
the effective control strength for each threat event.
}
\seealso{
Other OpenFAIR models: 
\code{\link{sample_tef}()}
}
\concept{OpenFAIR models}
