% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.credpart.R
\name{plot.credpart}
\alias{plot.credpart}
\title{Plotting a credal partition}
\usage{
\method{plot}{credpart}(x, X = NULL, ..., mfrow = c(1, 1), ytrue = NULL,
  Outliers = TRUE, Approx = 1, cex = 0.7, cex_outliers = 1.3, lwd = 2,
  ask = FALSE)
}
\arguments{
\item{x}{An object of class \code{"credpart"}, encoding a credal partition.}

\item{X}{A data matrix. If it has more than two columns (attributes), only the first two
columns are used.}

\item{...}{Other arguments to be passed to the plot function.}

\item{mfrow}{A 2-vector defining the number of rows and columns of the plot. If mfrow=c(1,1),
only one figure is drawn. Otherwise, mfrow[1] x mfrow[2] should not be less than x, the
number of clusters.}

\item{ytrue}{The vector of true class labels. If not supplied, the hard partition corresponding
to the maximum plausibility is used instead.}

\item{Outliers}{If TRUE, the outliers are plotted, and they are not included in the lower
and upper approximations of the clusters.}

\item{Approx}{If Approx==1 (default), the lower and upper cluster approximations are
computed using the interval dominance rule. Otherwise, the maximum mass rule is used.}

\item{cex}{Size of data points.}

\item{cex_outliers}{Size of data points for outliers.}

\item{lwd}{Line width for drawing the lower and upper approximations.}

\item{ask}{Logical; if TRUE, the user is asked before each plot.}
}
\value{
The maximum plausibility hard partition, as well as the lower and upper approximations
of each cluster are drawn in the two-dimensional space specified by matrix \code{X}. If
prototypes are defined (for methods \code{"ecm"} and \code{"cecm"}), they are also
represented on the plot.  For method \code{"kevclus"},  a second plot with Shepard's diagram (degrees
of conflict vs. transformed dissimilarities) is drawn. If input \code{X} is not supplied,
and \code{method=="kevclus"}, then only the Shepard diagram is drawn.
}
\description{
Generates plots of a credal partition.
}
\details{
This function plots the hard and rough partions (lower and upper approximations) extracted
from a credal partition, together with two dimensional attribute data.
}
\examples{
## Example with Four-class data
data("fourclass")
x<-fourclass[,1:2]
y<-fourclass[,3]
c=4
## Running k-EVCLUS with singletons
clus<-kevclus(x=x,k=100,c=c,type='simple')
## Plot the results
plot(clus,X=x,mfrow=c(2,2),ytrue=y)
}
\references{
T. Denoeux and O. Kanjanatarakul. Beyond Fuzzy, Possibilistic and Rough: An
Investigation of Belief Functions in Clustering. 8th International conference on soft
methods in probability and statistics, Rome, 12-14 September, 2016.

M.-H. Masson and T. Denoeux. ECM: An evidential version of the fuzzy c-means algorithm.
Pattern Recognition, Vol. 41, Issue 4, pages 1384--1397, 2008.

T. Denoeux, S. Sriboonchitta and O. Kanjanatarakul. Evidential clustering of large
dissimilarity data. Knowledge-Based Systems, vol. 106, pages 179-195, 2016.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{extractMass}}, \code{\link{summary.credpart}}, \code{\link{ecm}},
\code{\link{recm}}, \code{\link{cecm}}, \code{\link{kevclus}}.
}

