% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPrediction.R
\name{getPrediction}
\alias{getPrediction}
\title{Enrollment and event prediction}
\usage{
getPrediction(
  df = NULL,
  to_predict = "enrollment and event",
  target_n = NA,
  target_d = NA,
  enroll_model = "b-spline",
  nknots = 0,
  lags = 30,
  accrualTime = 0,
  enroll_prior = NULL,
  event_model = "model averaging",
  piecewiseSurvivalTime = 0,
  event_prior = NULL,
  dropout_model = "exponential",
  piecewiseDropoutTime = 0,
  dropout_prior = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  showEnrollment = TRUE,
  showEvent = TRUE,
  showDropout = FALSE,
  showOngoing = FALSE,
  showsummary = TRUE,
  showplot = TRUE
)
}
\arguments{
\item{df}{The subject-level enrollment and event data, including
\code{trialsdt}, \code{randdt}, \code{cutoffdt}, \code{time},
\code{event}, and \code{dropout}. By default, it is set to
\code{NULL} for enrollment and event prediction at the design stage.}

\item{to_predict}{Specifies what to predict: "enrollment only", "event
only", or "enrollment and event". By default, it is set to
"enrollment and event".}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{target_d}{The target number of events to reach in the study.}

\item{enroll_model}{The enrollment model which can be specified as
"Poisson", "Time-decay", "B-spline", or
"Piecewise Poisson". By default, it is set to "B-spline".}

\item{nknots}{The number of inner knots for the B-spline enrollment
model. By default, it is set to 0.}

\item{lags}{The day lags to compute the average enrollment rate to
carry forward for the B-spline enrollment model. By default,
it is set to 30.}

\item{accrualTime}{The accrual time intervals for the piecewise
Poisson model. Must start with 0, e.g., c(0, 30) breaks the
time axis into 2 accrual intervals: [0, 30) and [30, Inf).
By default, it is set to 0.}

\item{enroll_prior}{The prior of enrollment model parameters.}

\item{event_model}{The event model used to analyze the event data
which can be set to one of the
following options: "exponential", "Weibull", "log-normal",
"piecewise exponential", or "model averaging". The model averaging
uses the \code{exp(-bic/2)} weighting and combines Weibull and
log-normal models. By default, it is set to "model
averaging".}

\item{piecewiseSurvivalTime}{A vector that specifies the time
intervals for the piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{event_prior}{The prior of event model parameters.}

\item{dropout_model}{The dropout model used to analyze the dropout data
which can be set to one of the following options: "exponential",
"Weibull", "log-normal", or "piecewise exponential". By default,
it is set to "exponential".}

\item{piecewiseDropoutTime}{A vector that specifies the time
intervals for the piecewise exponential dropout distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{dropout_prior}{The prior of dropout model parameters.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nyears}{The number of years after the data cut for prediction.
By default, it is set to 4.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{showEnrollment}{A Boolean variable to control whether or not to
show the number of enrolled subjects. By default, it is set to
\code{TRUE}.}

\item{showEvent}{A Boolean variable to control whether or not to
show the number of events. By default, it is set to
\code{TRUE}.}

\item{showDropout}{A Boolean variable to control whether or not to
show the number of dropouts. By default, it is set to
\code{FALSE}.}

\item{showOngoing}{A Boolean variable to control whether or not to
show the number of ongoing subjects. By default, it is set to
\code{FALSE}.}

\item{showsummary}{A Boolean variable to control whether or not to
show the prediction summary. By default, it is set to \code{TRUE}.}

\item{showplot}{A Boolean variable to control whether or not to
show the plots. By default, it is set to \code{TRUE}.}
}
\value{
A list that includes the fits of observed data models,
as well as simulated enrollment data for new subjects and
simulated event data for ongoing and new subjects.
}
\description{
Performs enrollment and event prediction by utilizing
observed data and specified enrollment and event models.
}
\details{
For the time-decay model, the mean function is
\code{mu(t) = mu/delta*(t - 1/delta*(1 - exp(-delta*t)))}
and the rate function is
\code{lambda(t) = mu/delta*(1 - exp(-delta*t))}.
For the B-spline model, the daily enrollment rate is approximated as
\code{lambda(t) = exp(B(t)*theta)},
where \code{B(t)} represents the B-spline basis functions.

The \code{enroll_prior} variable should be a list that
includes \code{model} to specify the enrollment model
(poisson, time-decay, piecewise poisson),
\code{theta} and \code{vtheta} to indicate the parameter
values and the covariance matrix. One can use a very small
value of \code{vtheta} to fix the parameter values.
For the piecewise Poisson enrollment model, the list
should also include \code{accrualTime}. It should be noted
that the B-spline model is not appropriate for use as prior.

The \code{event_prior} variable should be a list that
includes \code{model} to specify the event model
(exponential, weibull, log-normal, piecewise exponential),
\code{ngroups} to indicate the number of treatment groups,
\code{alloc} to indicate the treatment allocation within a
randomization block, \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix, both of which
have \code{ngroups} blocks with the \code{j}-th block specifying
the prior distribution of model parameters for the \code{j}-th
treatment group. For the piecewise exponential event model,
the list should also include \code{piecewiseSurvivalTime} to indicate
the location of knots. It should be noted that the model averaging
option is not appropriate for use as prior.

The \code{dropout_prior} should be a list that
includes \code{model} to specify the dropout model,
(exponential, weibull, log-normal, piecewise exponential),
\code{ngroups} to indicate the number of treatment groups,
\code{alloc} to indicate the treatment allocation within a
randomization block, \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix, both of which
have \code{ngroups} blocks with the \code{j}-th block specifying
the prior distribution of model parameters for the \code{j}-th
treatment group. For the piecewise exponential dropout model,
the list should also include \code{piecewiseDropoutTime} to indicate
the location of knots.

For analysis-stage enrollment and event prediction, the
\code{enroll_prior}, \code{event_prior}, and
\code{dropout_prior} are either set to \code{NULL} to
use the observed data only, or specify the prior distribution
of model parameters to be combined with observed data likelihood
for enhanced modeling flexibility.
}
\examples{

# Event prediction after enrollment completion

pred <- getPrediction(
  df = interimData2, to_predict = "event only",
  target_d = 200,
  event_model = "weibull",
  dropout_model = "exponential",
  pilevel = 0.90, nreps = 100)

}
