% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo-modules.R
\name{pseudo_coxph}
\alias{pseudo_coxph}
\title{Compute censoring weighted pseudo observations}
\usage{
pseudo_coxph(
  formula,
  time,
  cause = 1,
  data,
  type = c("cuminc", "survival", "rmean"),
  formula.censoring = NULL,
  ipcw.method = NULL
)
}
\arguments{
\item{formula}{A formula specifying the outcome model. The left hand side must be a
\link[survival]{Surv} object specifying a right censored survival or
competing risks outcome. The status indicator, normally 0=alive, 1=dead.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death). For competing
risks, the event variable will be a factor, whose first level is treated as
censoring. The right hand side is the usual linear combination of
covariates.}

\item{time}{Numeric constant specifying the time at which the cumulative
incidence or survival probability effect estimates are desired.}

\item{cause}{Numeric or character constant specifying the cause indicator of
interest.}

\item{data}{Data frame in which all variables of formula can be interpreted.}

\item{type}{One of "survival", "cuminc", or "rmean"}

\item{formula.censoring}{A right-sided formula specifying which variables to
use in the model for the censoring distribution.}

\item{ipcw.method}{Which method to use for calculation of inverse
probability of censoring weighted pseudo observations. "binder" the
default, uses the number of observations as the denominator, while the
"hajek" method uses the sum of the weights as the denominator.}
}
\value{
A vector of pseudo observations
}
\description{
Assuming that the censoring depends on covariates,
the pseudo observations are calculated with the inverse probability of
censoring weighted approach, where the censoring probabilities are estimated
using Cox's proportional hazards model.
}
\examples{
POi <- pseudo_coxph(Surv(time, status) ~ 1, 1500, cause = 1,
  data = colon, type = "survival", formula.censoring = ~ sex + age,
  ipcw.method = "hajek")

mean(POi)

}
\seealso{
\link[survival]{coxph}
}
