% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_extractor.R
\name{coefficient_extractor.evzinb}
\alias{coefficient_extractor.evzinb}
\title{Bootstrap coefficient extractor}
\usage{
\method{coefficient_extractor}{evzinb}(
  object,
  component = c("nb", "zi", "evinf", "pareto", "all"),
  ...
)
}
\arguments{
\item{object}{A fitted evzinb model with bootstraps}

\item{component}{Which component should be extracted}

\item{...}{Not in use}
}
\value{
A tibble with coefficient values, one row per bootstrap and component
}
\description{
Bootstrap coefficient extractor
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
coefficient_extractor(model, component = 'all')

}
