% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MonteCarloStat.R
\name{MonteCarloRep}
\alias{MonteCarloRep}
\title{Parametric repeatabilities with covariance or correlation matrices}
\usage{
MonteCarloRep(cov.matrix, sample.size, ComparisonFunc, ..., iterations = 1000,
  correlation = FALSE, parallel = FALSE)
}
\arguments{
\item{cov.matrix}{Covariance matrix.}

\item{sample.size}{Size of the random populations.}

\item{ComparisonFunc}{comparison function.}

\item{...}{Aditional arguments passed to ComparisonFunc.}

\item{iterations}{Number of random populations.}

\item{correlation}{If TRUE, correlation matrix is used, else covariance matrix. MantelCor and MatrixCor should always uses correlation matrix.}

\item{parallel}{If is TRUE and list is passed, computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns the mean repeatability, or mean value of comparisons from samples to original statistic.
}
\description{
Using a multivariate normal model, random populations are generated
using the suplied covariance matrix. A statistic is calculated on the
random population and compared to the statistic calculated on the
original matrix.
}
\details{
Since this function uses multivariate normal model to generate populations, only covariance matrices should be used, even when computing repeatabilities for covariances matrices.
}
\examples{
cov.matrix <- RandomMatrix(5, 1, 1, 10)

MonteCarloRep(cov.matrix, sample.size = 30, RandomSkewers, iterations = 20)
MonteCarloRep(cov.matrix, sample.size = 30, RandomSkewers, num.vectors = 100,
              iterations = 20, correlation = TRUE)
MonteCarloRep(cov.matrix, sample.size = 30, MatrixCor, correlation = TRUE)
MonteCarloRep(cov.matrix, sample.size = 30, KrzCor, iterations = 20)
MonteCarloRep(cov.matrix, sample.size = 30, KrzCor, correlation = TRUE)

#Creating repeatability vector for a list of matrices
mat.list <- RandomMatrix(5, 3, 1, 10)
laply(mat.list, MonteCarloRep, 30, KrzCor, correlation = TRUE)

##Multiple threads can be used with doMC library
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#MonteCarloRep(cov.matrix, 30, RandomSkewers, iterations = 100, parallel = TRUE)
}
\author{
Diogo Melo Guilherme Garcia
}
\seealso{
\code{\link{BootstrapRep}}, \code{\link{AlphaRep}}
}
\keyword{montecarlo}
\keyword{parametricsampling}
\keyword{repeatability}

