% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivDriftTest.R
\name{MultivDriftTest}
\alias{MultivDriftTest}
\title{Multivariate genetic drift test for 2 populations}
\usage{
MultivDriftTest(
  population1,
  population2,
  G,
  Ne,
  generations,
  iterations = 1000
)
}
\arguments{
\item{population1}{data.frame with original measurements for the ancestral population}

\item{population2}{data.frame with original measurements for the derived population}

\item{G}{ancestral G matrix}

\item{Ne}{effective population size estimated for the populations}

\item{generations}{time in generations separating both populations}

\item{iterations}{number of simulations to perform}
}
\value{
list with the 95% IC magnitude of morphological change expected through 
drift and the range of the observed magnitude of morphological change
}
\description{
This function estimates populations evolving through drift from an ancestral 
population, given an effective population size, number of generations separating
them and the ancestral G-matrix. It calculates the magnitude of morphological 
divergence expected and compare it to the observed magnitude of morphological 
change.
}
\note{
Each trait is estimated independently.
}
\examples{
\dontrun{
data(dentus)
A <- dentus[dentus$species== "A",-5]
B <- dentus[dentus$species== "B",-5]
G <- cov(A)
MultivDriftTest(A, B, G, Ne = 1000, generations = 250)
}
}
\references{
Hohenlohe, P.A ; Arnold, S.J. (2008). MIPod: a hypothesis testing framework for 
microevolutionary inference from patterns of divergence. 
American Naturalist, 171(3),
366-385. doi: 10.1086/527498
}
\author{
Ana Paula Assis
}
