% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exCon.R
\name{exCon}
\alias{exCon}
\alias{exCon2}
\title{Explore Contour Data Interactively}
\usage{
exCon(M = NULL, x = seq(0, 1, length.out = nrow(M)), y = seq(0, 1,
  length.out = ncol(M)), nlevels = 5, levels = pretty(range(M, na.rm =
  TRUE), nlevels), browser = NULL, minify = TRUE)

exCon2(M = NULL, x = seq(0, 1, length.out = nrow(M)), y = seq(0, 1,
  length.out = ncol(M)), nlevels = 5, levels = pretty(range(M, na.rm =
  TRUE), nlevels), browser = NULL, minify = TRUE)
}
\arguments{
\item{M}{A matrix.}

\item{x}{A vector of numeric values giving the locations of the grid defining
the matrix.  Must have length \code{nrow(M)}.  These values become the scale
along the x axis.}

\item{y}{A vector of numeric values giving the locations of the grid defining
the matrix.  Must have length \code{ncol(M)}. These values become the scale
along the y axis.}

\item{nlevels}{Integer.  The number of contour levels desired.  Ignored if \code{levels}
is given.}

\item{levels}{Numeric.  A vector of values (altitudes if you will) at which to
compute the contours.}

\item{browser}{Character.  Something that will make sense to your OS.  Only
necessary if you want to overide your system specified browser as understood by
\code{R}.  See below for further details.}

\item{minify}{Logical.  Shall the JavaScript be minified?  This improves
performance.  However, it requires package \code{js} which in turn requires
package \code{V8}.  The latter is not available on all platforms.  Details
may be available at \url{https://github.com/jeroenooms/v8}}
}
\value{
The path to the temporary directory containing the web page files.
is returned invisibly.
The side effect is an interactive web page.  The temporary directory
is deleted when you quit R, but you can use the return value to
save the files to a different location.
}
\description{
These functions compute contour lines from matrix data and display them
in an interactive web page using the d3 javascript library. \code{exCon}
displays slices along the x and y directions.  \code{exCon2} does not
display the slices and is faster.
}
\section{Functions}{
\itemize{
\item \code{exCon}: Interactive contour display with slices

\item \code{exCon2}: Interactive contour display without slices
}}
\section{Details}{
 The computation of the contour lines is handled by
\code{\link[grDevices]{contourLines}}.  The result here, however, is transposed so that the
output has the same orientation as the original matrix. This is necessary because
\code{\link[graphics]{contour}} tranposes its output: "Notice that
\code{contour} interprets the \code{z} matrix as a table of 
\code{f(x[i], y[j])} values, so that the x axis corresponds to row number
and the y axis to column number, with column 1 at the bottom, i.e. a 90 degree
counter-clockwise rotation of the conventional textual layout."
}

\section{Interpretation}{
  The contour lines are an interpolation of the data
in the matrix.  In \code{exCon}, the slices are the actual values in the matrix
row or column
connected point-to-point.  Thus a maximum in a slice may not correspond to 
a peak in the contour plot.
}

\section{Browser Choice}{
 The browser is called by
\code{\link[utils]{browseURL}}, which
in turn uses \code{options("browser")}.  Exactly how this is handled
is OS dependent.
}

\section{Firefox Browser}{

the slices chosen and the values displayed are correct.
}

\section{RStudio Viewer}{
 If browser is \code{NULL}, you are using RStudio,
and a viewer is specified, this will be called.  You can stop this by with
\code{options(viewer = NULL)}.
}

\section{Browser Choice (Mac)}{
 On a Mac, the default browser is called
by \code{/bin/sh/open}
which in turn looks at which browser you have set in the system settings.  You can
override your default with
\code{browser = "/usr/bin/open -a 'Google Chrome'"} for example.
}

\section{Browser Choice & Performance}{
  You can check the performance of
your browser at peacekeeper.futuremark.com  The most relevant score for
exCon is the rendering category.
}

\section{Performance Limits (YMMV)}{
 On a early 2015 MacBook Pro, with 16 Gb
RAM and an 2.9 GHz Intel Core i5 chip, a
1500 x 1500 matrix with 1 contour level 
requires about 15 seconds for R to render the web page using Chrome, Safari
or Firefox. A 2K x 2K matrix appears to be too large to handle.  R seems
to hang during the handoff to the browser.
}
\examples{
if (interactive()) {
require(jsonlite)

# minify is FALSE in the examples as not all platforms support the required pkgs (see above)

exCon(M = volcano, minify = FALSE)

exCon2(M = volcano, minify = FALSE) # no slices

# This next example will label the axes with the actual values, relative to the
# lower left corner (original data collected on 10 meter grid).  Giving
# x and y affects only the scale, and the native values displayed at the top.

 exCon(M = volcano, minify = FALSE,
 x = seq(from = 0, by = 10, length.out = nrow(volcano)),
 y = seq(from = 0, by = 10, length.out = ncol(volcano)))
}

}
\keyword{interactive}
\keyword{plot}

