% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{smooth_pdf}
\alias{smooth_pdf}
\title{Smooths a pdf}
\usage{
smooth_pdf(x, p_x)
}
\arguments{
\item{x}{a vector corresponding to values of a random variable X (length strictly greater than 1)}

\item{p_x}{a vector containing the density of the RV X at locations \code{x}}
}
\value{
The normalized pdf
}
\description{
\code{smooth_pdf} smooths a pdf using convolution with a kernel
}
\examples{
x <- seq(from=-5,to=5,by=0.1)
p_x <- dnorm(x) + rnorm(length(x),mean=0,sd=0.02)
p_x <- pmax(p_x,0)
plot(x,p_x,type='l')
res <- smooth_pdf(x,p_x)
lines(x,res$p_x,col='red')
}
