% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_GridSearch.R
\name{GridSearch}
\alias{GridSearch}
\title{Grid Search for Optimal Parameters}
\usage{
GridSearch(
  obj,
  max_ncls = 10,
  max_nfld = 10,
  fun = "Biclustering",
  index = "BIC",
  ...
)
}
\arguments{
\item{obj}{Input data matrix or object to be analyzed}

\item{max_ncls}{Maximum number of classes/clusters to test (default: 10)}

\item{max_nfld}{Maximum number of fields to test for
Biclustering (default: 10)}

\item{fun}{Function name to use for analysis.
Options: "Biclustering", "LCA", "LRA" (default: "Biclustering")}

\item{index}{Fit index to optimize from TestFitIndices returned by
each function. Options: "AIC", "BIC", etc. (default: "BIC")}

\item{...}{Additional arguments passed to the analysis function}
}
\value{
A list containing:
For Biclustering:
\item{index_matrix}{Matrix of fit indices for each
ncls/nfld combination}
\item{optimal_ncls}{Optimal number of classes/clusters}
\item{optimal_nfld}{Optimal number of fields}
\item{optimal_result}{Analysis result using optimal parameters}

For LCA/LRA:
\item{index_vec}{Vector of fit indices for each ncls}
\item{optimal_ncls}{Optimal number of classes/clusters}
\item{optimal_result}{Analysis result using optimal parameters}
}
\description{
Performs a grid search to find optimal parameters for different
analysis methods.
Supports Biclustering, LCA (Latent Class Analysis),
and LRA (Latent Rank Analysis).
}
\examples{
\dontrun{
# Grid search for Biclustering
result <- grid_serch(data_matrix, max_ncls = 5, max_nfld = 5)

# Grid search for LCA
result <- grid_serch(data_matrix, max_ncls = 8, fun = "LCA")
}

}
