% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{extract_examples}
\alias{extract_examples}
\title{Extract examples lines from the functions in a .R file of a package.}
\usage{
extract_examples(r_file_name, pkg_dir = ".", document = TRUE)
}
\arguments{
\item{r_file_name}{The name of the \code{.R} file within \code{R/}. There's no need to
specify the file path (as \code{R/x.R}, but you can do this if you want), you
can just use \code{x.R} for whichever file \code{x} it is. You can also omit the \code{.R}
for convenience, however using the wrong case (e.g. \code{.r}) will produce an
error.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). This is the parent directory of \code{R/} and \code{man/}. In
reality, this specification is somewhat lenient and even if you are in any
sub-directory of the root, it will work (e.g. it will work if you are in
\code{R/} or \code{man/}). Beware that this behaviour can cause a problem if you have
an R package inside an R package (but really, you have yourself to blame if
that's the case).}

\item{document}{Run \code{\link[devtools:document]{devtools::document()}} to update package documentation
before starting?}
}
\value{
A list of character vectors.
}
\description{
In each \code{.R} file in the \code{R/} folder of a package project, for the functions
defined therein, there can corresponding examples in the \code{.Rd} files of the
man/` folder. This function extracts those examples into a list of character
vectors, one list element for each documented function.
}
\details{
Anything found within a \code{\\dontrun\{...\}} block is ignored.
}
\examples{
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", "detect.R", package = "exampletestr"), "R")
devtools::document()
exampletestr::extract_examples("detect")
setwd("..")
filesstrings::dir.remove("tempkg")

}
