% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{test-shells}
\alias{test-shells}
\alias{make_test_shell_fun}
\alias{make_tests_shells_file}
\alias{make_tests_shells_pkg}
\title{Create test shells.}
\usage{
make_test_shell_fun(fun, pkg_dir = ".", overwrite = FALSE, e_e = TRUE,
  open = TRUE, document = TRUE)

make_tests_shells_file(r_file_name, pkg_dir = ".", overwrite = FALSE,
  e_e = TRUE, open = TRUE, document = TRUE)

make_tests_shells_pkg(pkg_dir = ".", overwrite = FALSE, e_e = TRUE,
  open = FALSE, document = TRUE)
}
\arguments{
\item{fun}{The name of the function to make a test shell for.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). Note that this is the parent directory of R/.}

\item{overwrite}{Overwrite if the test file you're trying to create already
exists?}

\item{e_e}{Set this to \code{FALSE} to prevent anything from being put in the
shell of an \code{expect_equal()} statement.}

\item{open}{Open the created test file in your editor after it is created?}

\item{document}{Run \code{\link[devtools:document]{devtools::document()}} to update package documentation
before starting?}

\item{r_file_name}{The name of the \code{.R} file within \code{R/}. There's no need to
specify the file path (as \code{R/x.R}, but you can do this if you want), you
can just use \code{x.R} for whichever file \code{x} it is. You can also omit the \code{.R}
for convenience, however using the wrong case (e.g. \code{.r} when the file
actually has the extension \code{.R}) will produce an error.}
}
\value{
The shell of the test file is written into tests/testthat. It has the
same name as the .R file it was created from except it has "test_" tacked
onto the front.
}
\description{
\itemize{\item For a given function \code{fun()} in a package,
\link[=test-shells]{make_test_shell_fun()} checks if there are examples for that
function detailed in the \code{man/} directory (in a \code{.Rd} file) and if so creates
a shell (skeleton) of a \code{\link[testthat:test_that]{testthat::test_that()}} test based on those examples
via \link[=test-shells]{make_test_shell()}. The created shell is then written to a
corresponding file \code{test-fun-examples.R} in \code{tests/testthat}. \item For a
given file \code{x.R} in the \code{R/} directory of a package, for each function
defined in that \code{.R} file, \link[=test-shells]{make_tests_shells_file()} checks if
there are examples for that function detailed in the \code{man/} directory (in a
\code{.Rd} file) and if so creates a shell (skeleton) of a \code{\link[testthat:test_that]{testthat::test_that()}}
test based on those examples via \link[=test-shells]{make_test_shell()}. The
created shells are then written to a corresponding file \code{test-x-examples.R}
in \code{tests/testthat}. \item \link[=test-shells]{make_test_shells_pkg()} runs
\link[=test-shells]{make_test_shells_file()} on every \code{.R} file in the \code{R/}
directory of a package.}
}
\examples{
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", "detect.R", package = "exampletestr"), "R")
make_test_shell_fun("str_detect()", document = TRUE, open = FALSE)
make_tests_shells_file("detect", document = FALSE, open = FALSE)
make_tests_shells_pkg(overwrite = TRUE, document = FALSE)
setwd("..")
filesstrings::dir.remove("tempkg")

}
