% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{renderExcel}
\alias{renderExcel}
\title{Helper function for using jexcel table in Shiny}
\usage{
renderExcel(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{an expression that generates an excelTable.}

\item{env}{the environment in which to evaluate expr.}

\item{quoted}{is expr a quoted expression(with quote())? This is useful if you want to save an expression in a variable.}
}
\description{
Shiny bindings for excel table
}
\examples{
if(interactive()) {
  library(shiny)
  library(excelR)
  shinyApp(
    ui = fluidPage(excelOutput("table")),
    server = function(input, output, session) {
      output$table <-
     renderExcel(excelTable(data = head(iris)))
     }
   )
}
}
\seealso{
\code{\link{excelOutput}}
}
