% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_na_percent.R
\name{strip_na_percent}
\alias{strip_na_percent}
\title{Remove Rows of a Data Frame by Percent NA Values}
\usage{
strip_na_percent(.df, greater_than = 0.25)
}
\arguments{
\item{.df}{a data.frame object}

\item{greater_than}{double. The cutoff percent of NA values in a row to remove that row.
Defaults to 0.25}
}
\value{
a data frame with specified rows removed.
}
\description{
Remove Rows of a Data Frame by Percent NA Values
}
\examples{
df <- data.frame(A = runif(5), B = runif(5), C = runif(5))
df$B[3:4] <- NA
df$C[4] <- NA
strip_na_percent(df, greater_than = .5)
}
