% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_methods.R
\name{coef.spm}
\alias{coef.spm}
\title{Extract Model Coefficients from an \code{"spm"} object}
\usage{
\method{coef}{spm}(
  object,
  maxima = c("sliding", "disjoint"),
  estimator = "all",
  constrain = FALSE,
  ...
)
}
\arguments{
\item{object}{and object of class \code{c("spm", "exdex")} returned from
\code{\link{spm}}.}

\item{maxima}{A character scalar specifying whether to return the estimate
of the extremal index \eqn{\theta} based on sliding maxima or on disjoint
maxima.}

\item{estimator}{A character vector specifying which of the three variants
of the semiparametric maxima estimator to use: \code{"N2015", "BB2018"}
or \code{"BB2018b"}.  See \code{\link{spm}} for details.
If \code{estimator = "all"} then all three estimates are returned.}

\item{constrain}{A logical scalar.  If \code{constrain = TRUE} then
any estimates that are greater than 1 are set to 1,
that is, they are constrained to lie in (0, 1].  Otherwise,
estimates that are greater than 1 may be obtained.}

\item{...}{Further arguments.  None are used.}
}
\value{
A numeric scalar (or a vector of length 2 if
  \code{estimator = "both"}): the required estimate(s) of the extremal index
  \eqn{\theta}.
}
\description{
\code{coef} method for class \code{c("spm", "exdex")}.
}
\references{
Northrop, P. J. (2015) An efficient semiparametric maxima
estimator of the extremal index. \emph{Extremes} \strong{18}(4), 585-603.
\doi{10.1007/s10687-015-0221-5}

Berghaus, B., Bucher, A. (2018) Weak convergence of a pseudo
maximum likelihood estimator for the extremal index. \emph{Ann. Statist.}
\strong{46}(5), 2307-2335. \doi{10.1214/17-AOS1621}
}
