% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{kgaps_confint}
\alias{kgaps_confint}
\alias{confint.kgaps}
\alias{plot.confint_kgaps}
\alias{print.confint_kgaps}
\title{Confidence intervals for the extremal index \eqn{\theta} for \code{"kgaps"}
objects}
\usage{
\method{confint}{kgaps}(
  object,
  parm = "theta",
  level = 0.95,
  interval_type = c("both", "norm", "lik"),
  conf_scale = c("theta", "log"),
  constrain = TRUE,
  se_type = c("observed", "expected"),
  ...
)

\method{plot}{confint_kgaps}(x, ...)

\method{print}{confint_kgaps}(x, ...)
}
\arguments{
\item{object}{An object of class \code{c("kgaps", "exdex")}, returned by
\code{\link{kgaps}}.}

\item{parm}{Specifies which parameter is to be given a confidence interval.
Here there is only one option: the extremal index \eqn{\theta}.}

\item{level}{The confidence level required.  A numeric scalar in (0, 1).}

\item{interval_type}{A character scalar: \code{"norm"} for intervals of
type (a), \code{"lik"} for intervals of type (b).}

\item{conf_scale}{A character scalar.  If \code{interval_type = "norm"} then
  \code{conf_scale} determines the scale on which we use approximate
  large-sample normality of the estimator to estimate confidence intervals.

  If \code{conf_scale = "theta"}
  then confidence intervals are estimated for \eqn{\theta} directly.
  If \code{conf_scale = "log"} then confidence intervals are first
  estimated for \eqn{\log\theta}{log\theta} and then transformed back
  to the \eqn{\theta}-scale.}

\item{constrain}{A logical scalar.  If \code{constrain = TRUE} then
any confidence limits that are greater than 1 are set to 1,
that is, they are constrained to lie in (0, 1].  Otherwise,
limits that are greater than 1 may be obtained.
If \code{constrain = TRUE} then any lower confidence limits that are
less than 0 are set to 0.}

\item{se_type}{A character scalar. Should the confidence intervals for the
\code{interval_type  = "norm"} use the estimated standard error based on
the observed information or based on the expected information?}

\item{...}{\code{plot.confint_kgaps}: further arguments passed to
  \code{\link[chandwich]{plot.confint}}.

  \code{print.confint_kgaps}: further arguments passed to
  \code{\link{print.default}}.}

\item{x}{an object of class \code{c("confint_kgaps", "exdex")}, a result of
a call to \code{\link{confint.kgaps}}.}
}
\value{
A list of class c("confint_kgaps", "exdex") containing the
  following components.
  \item{cis}{A matrix with columns giving the lower and upper confidence
  limits. These are labelled as (1 - level)/2 and 1 - (1 - level)/2 in
  \% (by default 2.5\% and 97.5\%).
  The row names indicate the type of interval:
  \code{norm} for intervals based on large sample normality and \code{lik}
  for likelihood-based intervals.}
  \item{call}{The call to \code{spm}.}
  \item{object}{The input object \code{object}.}
  \item{level}{The input \code{level}.}

\code{plot.confint_kgaps}: nothing is returned.

\code{print.confint_kgaps}: the argument \code{x}, invisibly.
}
\description{
\code{confint} method for objects of class \code{c("kgaps", "exdex")}.
Computes confidence intervals for \eqn{\theta} based on an object returned
from \code{\link{kgaps}}.  Two types of interval may be returned:
(a) intervals based on approximate large-sample normality of the estimator
of \eqn{\theta}, which are symmetric about the point estimate,
and (b) likelihood-based intervals. The \code{plot} method plots the
log-likelihood for \eqn{\theta}, with the required confidence interval
indicated on the plot.
}
\details{
Two type of interval are calculated: (a) an interval based on the
  approximate large sample normality of the estimator of \eqn{\theta}
  (if \code{conf_scale = "theta"}) or of \eqn{\log\theta}{log\theta}
  (if \code{conf_scale = "log"}) and (b) a likelihood-based interval,
  based on the approximate large sample chi-squared, with 1 degree of
  freedom, distribution of the log-likelihood ratio statistic.

\code{print.confint_kgaps} prints the matrix of confidence
  intervals for \eqn{\theta}.
}
\examples{
u <- quantile(newlyn, probs = 0.90)
theta <- kgaps(newlyn, u)
cis <- confint(theta)
cis
plot(cis)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}
}
\seealso{
\code{\link{kgaps}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.
}
