% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exif_read.R
\name{exif_read}
\alias{exif_read}
\title{Read EXIF and other metadata from files}
\usage{
exif_read(path, tags = NULL, recursive = FALSE, args = NULL, quiet = TRUE)
}
\arguments{
\item{path}{A vector of filenames.}

\item{tags}{A vector of tags to output. It is a good idea to
specify this when reading large numbers of files, as it
decreases the output overhead significantly. Spaces will be
stripped in the output data frame. This parameter is not
case-sensitive.}

\item{recursive}{\code{TRUE} to pass the \code{"-r"} option to
ExifTool.}

\item{args}{Additional arguments.}

\item{quiet}{Use \code{FALSE} to display diagnostic
information. Default value is \code{TRUE}}
}
\value{
A data frame of class \code{"exiftoolr"} with one row per
    file processed. The first column, named \code{"SourceFile"}
    gives the name(s) of the processed files. Subsequent columns
    contain info from the tags read from those files.

    Note that binary tags such as thumbnails are loaded as
    \href{https://en.wikipedia.org/wiki/Base64}{base64-encoded
    strings} that start with \code{"base64:"}. Although these are
    truncated in the printed representation of the
    \code{data.frame} returned by the function, they are left
    unaltered in the \code{data.frame} itself.
}
\description{
Reads EXIF and other metadata into a \code{data.frame} by calling
Phil Harvey's ExifTool command-line application.
}
\details{
From the \href{https://exiftool.org}{ExifTool website}:
"ExifTool is a platform-independent Perl library plus a
command-line application for reading, writing and editing meta
information in a wide variety of files. ExifTool supports many
different metadata formats including EXIF, GPS, IPTC, XMP, JFIF,
GeoTIFF, ICC Profile, Photoshop IRB, FlashPix, AFCP and ID3, as
well as the maker notes of many digital cameras by Canon, Casio,
DJI, FLIR, FujiFilm, GE, GoPro, HP, JVC/Victor, Kodak, Leaf,
Minolta/Konica-Minolta, Motorola, Nikon, Nintendo, Olympus/Epson,
Panasonic/Leica, Pentax/Asahi, Phase One, Reconyx, Ricoh, Samsung,
Sanyo, Sigma/Foveon and Sony."

For more information, see the \href{https://exiftool.org}{ExifTool
website}.
}
\examples{
\dontrun{
files <- dir(system.file(package = "exiftoolr", "images"),
             pattern = "*.jpg", full.names = TRUE)
exif_read(files)
exif_read(files, tags = c("filename", "imagesize"))
}
}
\references{
\url{https://exiftool.org}
}
