% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow_up.R
\name{follow_up2}
\alias{follow_up2}
\title{Follow up experiments in batches}
\usage{
follow_up2(all_data, batch_column = "batch", ...)
}
\arguments{
\item{all_data}{A \code{data.frame} with all the data about the samples.
Each row is a sample.}

\item{batch_column}{The name of the column of \code{all_data} with the batches used.
If NA it is interpreted as a new data, if not empty it is considered a batch.}

\item{...}{
  Arguments passed on to \code{\link[=design]{design}}
  \describe{
    \item{\code{size_subset}}{Numeric value of the number of sample per batch.}
    \item{\code{omit}}{Name of the columns of the \code{pheno} that will be omitted.}
    \item{\code{iterations}}{Numeric value of iterations that will be performed.}
    \item{\code{name}}{A character used to name the subsets, either a single one or a
vector the same size as \code{n}.}
  }}
}
\value{
A \code{data.frame} with the \code{batch_column} filled with the new batches needed.
}
\description{
Design experiment with all the data new and old together.
}
\details{
If the \code{batch_column} is empty the samples are considered new.
If the \code{size_subset} is missing, it will be estimated from the previous batch
Similarly, iterations and name will be guessed or inferred from the samples.
}
\examples{
data(survey, package = "MASS")
# Create the first batch
first_batch_n <- 118
variables <- c("Sex", "Smoke", "Age")
survey1 <- survey[seq_len(first_batch_n), variables]
index1 <- design(survey1, size_subset = 50, iterations = 10)
r_survey <- inspect(index1, survey1)
# Create the second batch with "new" students
survey2 <- survey[seq(from = first_batch_n +1, to = nrow(survey)), variables]
survey2$batch <- NA
# Prepare the follow up
all_classroom <- rbind(r_survey, survey2)
follow_up2(all_classroom, size_subset = 50, iterations = 10)
}
\seealso{
\code{\link[=follow_up]{follow_up()}}
}
