% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_category.R
\name{evaluate_entropy}
\alias{evaluate_entropy}
\title{Evaluate entropy}
\usage{
evaluate_entropy(i, pheno)
}
\arguments{
\item{i}{list of numeric indices of the data.frame}

\item{pheno}{Data.frame with information about the samples}
}
\value{
Value to minimize
}
\description{
Looks if the nominal or character columns are equally distributed according
to the entropy and taking into account the independence between batches.
If any column is different in each row it is assumed to be the sample names
and thus omitted.
}
\examples{
data(survey, package = "MASS")
index <- design(survey[, c("Sex", "Smoke", "Age")], size_subset = 50,
                iterations = 10)
# Note that numeric columns will be omitted:
evaluate_entropy(index, survey[, c("Sex", "Smoke", "Age")])
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_independence}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_orig}()},
\code{\link{evaluate_sd}()}

Other functions to evaluate categories: 
\code{\link{evaluate_independence}()},
\code{\link{evaluate_na}()}
}
\concept{functions to evaluate categories}
\concept{functions to evaluate samples}
