% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot}
\alias{scatterplot}
\title{Scatterplot}
\usage{
scatterplot(
  data = NULL,
  x_var_name = NULL,
  y_var_name = NULL,
  point_label_var_name = NULL,
  weight_var_name = NULL,
  alpha = 1,
  annotate_stats = FALSE,
  annotate_y_pos = 5,
  line_of_fit_type = "lm",
  ci_for_line_of_fit = FALSE,
  x_axis_label = NULL,
  y_axis_label = NULL,
  point_label_size = NULL,
  point_size_range = c(3, 12),
  jitter_x_percent = 0,
  jitter_y_percent = 0,
  cap_axis_lines = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{x_var_name}{name of the variable that will go on the x axis}

\item{y_var_name}{name of the variable that will go on the y axis}

\item{point_label_var_name}{name of the variable that will be used to
label individual observations}

\item{weight_var_name}{name of the variable by which to weight
the individual observations for calculating correlation and plotting
the line of fit}

\item{alpha}{opacity of the dots (0 = completely transparent,
1 = completely opaque)}

\item{annotate_stats}{if \code{TRUE}, the correlation and p-value will
be annotated at the top of the plot}

\item{annotate_y_pos}{position of the annotated stats, expressed
as a percentage of the range of y values by which the annotated
stats will be placed above the maximum value of y in the data set
(default = 5). If \code{annotate_y_pos = 5}, and the minimum and
maximum y values in the data set are 0 and 100, respectively,
the annotated stats will be placed at 5\% of the y range (100 - 0)
above the maximum y value, y = 0.05 * (100 - 0) + 100 = 105.}

\item{line_of_fit_type}{if \code{line_of_fit_type = "lm"}, a regression
line will be fit; if \code{line_of_fit_type = "loess"}, a local
regression line will be fit; if \code{line_of_fit_type = "none"},
no line will be fit}

\item{ci_for_line_of_fit}{if \code{ci_for_line_of_fit = TRUE},
confidence interval for the line of fit will be shaded}

\item{x_axis_label}{alternative label for the x axis}

\item{y_axis_label}{alternative label for the y axis}

\item{point_label_size}{size for dots' labels on the plot. If no
input is entered for this argument, it will be set as
\code{point_label_size = 5} by default. If the plot is to be
weighted by some variable, this argument will be ignored, and
dot sizes will be determined by the argument \code{point_size_range}}

\item{point_size_range}{minimum and maximum size for dots
on the plot when they are weighted}

\item{jitter_x_percent}{horizontally jitter dots by a percentage of the
range of x values}

\item{jitter_y_percent}{vertically jitter dots by a percentage of the
range of y values}

\item{cap_axis_lines}{logical. Should the axis lines be capped at the
outer tick marks? (default = TRUE)}
}
\value{
the output will be a scatter plot, a ggplot object.
}
\description{
Creates a scatter plot and calculates a correlation between two variables
}
\examples{
\donttest{
scatterplot(data = mtcars, x_var_name = "wt", y_var_name = "mpg")
scatterplot(
  data = mtcars, x_var_name = "wt", y_var_name = "mpg",
  point_label_var_name = "hp", weight_var_name = "drat",
  annotate_stats = TRUE
)
scatterplot(
  data = mtcars, x_var_name = "wt", y_var_name = "mpg",
  point_label_var_name = "hp", weight_var_name = "cyl",
  point_label_size = 7, annotate_stats = TRUE
)
}
}
