% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{add_random_var}
\alias{add_random_var}
\title{Add a random variable to dataset}
\usage{
add_random_var(
  data,
  name = "random",
  min_val = 0,
  max_val = 1,
  overwrite = TRUE
)
}
\arguments{
\item{data}{A dataset}

\item{name}{Name of new variable (as string)}

\item{min_val}{Minimum random integers}

\item{max_val}{Maximum random integers}

\item{overwrite}{Can new random variable overwrite an existing variable in dataset?}
}
\value{
Dataset containing new random variable
}
\description{
Add a random variable to dataset
}
\examples{
add_random_var(iris)
add_random_var(iris, name = "random_var")
add_random_var(iris, min_val = 1, max_val = 10)
add_random_var(iris, min_val = 1, max_val = 100, overwrite = FALSE)
}
