% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl2bitmap.R
\name{rgl2bitmap}
\alias{rgl2bitmap}
\alias{rgl2png}
\alias{rgl2png}
\title{Save currently active rgl 3D graph to bitmap format}
\usage{
rgl2bitmap(file = "Rplot", type = c("PNG"))

rgl2png(...)
}
\arguments{
\item{file}{name of output file. Any extension is ignored and added
according to the requested output type. If file already exists it is overwritten.}

\item{type}{desired output type - currently only \code{PNG} is supported.}

\item{\dots}{passing the \code{rgl2png} arguments to \code{rgl2bitmap}}
}
\value{
\code{NULL}
}
\description{
Save currently active rgl 3D graph to bitmap format in current orientation
}
\section{Functions}{
\itemize{
\item \code{rgl2png}: Save currently active rgl 3D graph to PNG format
}}

\examples{
# Create a file name
filen <- tempfile(pattern = "rgl") # or 
# filen <- paste("YOUR_DIR/rgl")

# Generate a 3D plot using 'rgl'
x = y = seq(-10, 10, length = 20)
z = outer(x, y, function(x, y) x^2 + y^2)
rgl::persp3d(x, y, z, col = 'lightblue')

# Save the plot as a png
rgl2png(file = filen)
# Note that omitting 'file' will save in current directory
}
\author{
Tom Wenseleers
}
