% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_experimental.R
\name{compute}
\alias{.add_val_lab}
\alias{.compute}
\alias{.cro}
\alias{.cro_cpct}
\alias{.cro_fun}
\alias{.cro_fun_df}
\alias{.cro_mean}
\alias{.cro_median}
\alias{.cro_rpct}
\alias{.cro_sum}
\alias{.cro_tpct}
\alias{.do_if}
\alias{.fre}
\alias{.if_val}
\alias{.modify}
\alias{.modify_if}
\alias{.recode}
\alias{.set}
\alias{.set_val_lab}
\alias{.set_var_lab}
\alias{.val_lab}
\alias{.var_lab}
\alias{.with}
\alias{compute}
\title{Experimental functions for operations with default dataset}
\usage{
.modify(expr)

.modify_if(cond, expr)

.do_if(cond, expr)

.compute(expr)

.with(expr, ...)

.val_lab(...)

.var_lab(...)

.set_var_lab(x, ...)

.set_val_lab(x, ...)

.add_val_lab(x, ...)

.if_val(x, ...)

.recode(x, ...)

.fre(...)

.cro(...)

.cro_cpct(...)

.cro_rpct(...)

.cro_tpct(...)

.cro_mean(...)

.cro_sum(...)

.cro_median(...)

.cro_fun(...)

.cro_fun_df(...)

.set(varnames, value = NA)
}
\arguments{
\item{expr}{set of expressions  in curly brackets which will be evaluated in
the context of default dataset}

\item{cond}{logical vector/expression}

\item{...}{further arguments}

\item{x}{vector/data.frame - variable names in the scope of default dataset}

\item{varnames}{character vector. Names of variables which should be created
in the default dataset. Expressions inside backticks in \code{varnames}
will be expanded as with \link{subst}.}

\item{value}{value/vector/matrix/data.frame. Value for newly created/existing
variables.}
}
\description{
Workflow for these functions is rather simple. You should set up default 
data.frame with \link{default_dataset} and then operate with it without any 
reference to your data.frame. There are two kinds of operations. The first kind
modify default dataset, the second kind will be evaluated in the context of
the default dataset but doesn't modify it. It is not recommended to use one
of these functions in the scope of another of these functions. By now their
performance is not so high, especially \code{.do_if}/\code{.modify_if} can be
very slow.
}
\details{
Functions which modify default dataset:
\itemize{
\item{\code{.modify}}{ Add and modify variables inside default data.frame. See
\link{modify}.}
\item{\code{.compute}}{ Shortcut for \code{.modify}. Name is inspired by
SPSS COMPUTE operator. See \link{modify}.}
\item{\code{.modify_if}}{ Add and modify variables inside subset of default
data.frame. See \link{modify_if}.}
\item{\code{.do_if}}{ Shortcut for \code{.modify_if}. Name is inspired by
SPSS DO IF operator. See \link{modify_if}.}
\item{\code{.where}}{ Leave subset of default data.frame which meet
condition. See \link{where}, \link[base]{subset}.}
\item{\code{.set_var_lab}}{ Set variable label in the default data.frame. See
\link{set_var_lab}.}
\item{\code{.set_val_lab}}{ Set value labels for variable in the default
data.frame. See \link{set_val_lab}.}
\item{\code{.add_val_lab}}{ Add value labels for variable in the default
data.frame. See \link{add_val_lab}.}
\item{\code{.if_val}}{ Change, rearrange or consolidate the values of an existing
variable inside default data.frame. See \link{if_val}.}
\item{\code{.recode}}{ Shortcut for \code{.if_val}. Name is inspired by
SPSS RECODE. See \link{if_val}.}
\item{\code{.set}}{ Set variables values in the default dataset with given 
names filled with \code{value}. It is possible to set multiple variables at 
once. Expressions inside backticks in \code{varnames} will be expanded as
with \link{subst}. \code{set} (without dot) is also available inside
\code{.compute}, \code{.modify}, \code{.modify_if}, \code{.do_if},
\link{modify}, \link{modify_if}.} }
Other functions:
\itemize{
\item{\code{.var_lab}}{ Return variable label from default dataset. See
\link{var_lab}.}
\item{\code{.val_lab}}{ Return value labels from default dataset. See
\link{val_lab}.}
\item{\code{.fre }}{ Simple frequencies of variable in the default
data.frame.  See \link{fre}.}
\item{\code{.cro}/\code{.cro_cpct}/\code{.cro_rpct}/\code{.cro_tpct}}{ Simple
crosstabulations of variable in the default data.frame.  See \link{cro}.}
\item{\code{.cro_mean}/\code{.cro_sum}/\code{.cro_median}/\code{.cro_fun}/\code{.cro_fun_df}}{
Simple crosstabulations of variable in the default data.frame.  See 
\link{cro_fun}.}
\item{\code{.with}}{ Evaluate arbitrary expression in the context of
data.frame.  See \link[base]{with}.}
}
}
\examples{
data(mtcars)

default_dataset(mtcars) # set mtcars as default dataset

# calculate new variables
.compute({
    mpg_by_am = ave(mpg, am, FUN = mean)
    hi_low_mpg = ifs(mpg<mean(mpg) ~ 0, default = 1)    
})

# set labels
.set_var_lab(mpg, "Miles/(US) gallon")
.set_var_lab(cyl, "Number of cylinders")
.set_var_lab(disp, "Displacement (cu.in.)")
.set_var_lab(hp, "Gross horsepower")
.set_var_lab(mpg_by_am, "Average mpg for transimission type")
.set_var_lab(hi_low_mpg, "Miles per gallon")
.set_val_lab(hi_low_mpg, ml_left("
                                  0 Low
                                  1 High
                                  "))

.set_var_lab(vs, "Engine")
.set_val_lab(vs, ml_left(" 
                          0 V-engine
                          1 Straight engine
                          "))

.set_var_lab(am, "Transmission")
.set_val_lab(am, ml_left(" 
                          0 automatic
                          1 manual
                          "))

# calculate frequencies
.fre(hi_low_mpg)
.cro(cyl, hi_low_mpg)
.cro_mean(mpg, am)
.cro_mean(data.frame(mpg, disp, hp), vs)

# disable default dataset
default_dataset(NULL)

# Example of .recode

data(iris)

default_dataset(iris) # set iris as default dataset

.recode(Sepal.Length, lo \%thru\% median(Sepal.Length) ~ "small", other ~ "large")

.fre(Sepal.Length)

# example of .do_if
 
.do_if(Species == "setosa",{
     Petal.Length = NA
     Petal.Width = NA
})

.cro_mean(data.frame(Petal.Length, Petal.Width), Species)

# disable default dataset
default_dataset(NULL)
}

