% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{.except}
\alias{.keep}
\alias{\%except\%}
\alias{\%keep\%}
\alias{except}
\alias{keep}
\title{Keep or drop elements by name/criteria in data.frame/matrix/list/vector}
\usage{
keep(data, ...)

except(data, ...)

data \%keep\% variables

data \%except\% variables

.keep(...)

.except(...)
}
\arguments{
\item{data}{data.frame/matrix/list/vector}

\item{...}{column names/element names of type character or criteria/logical functions}

\item{variables}{column names/element names of type character or criteria/logical functions}
}
\value{
object of the same type as \code{data}
}
\description{
\code{keep} selects variables/elements from data.frame by their names or by 
criteria (see \link{criteria}). \code{except} drops  variables/elements from 
data.frame by their names or by criteria. There is no non-standard evaluation
in these functions by design so use quotes for names of your variables or use
\link{qc}. \code{\%keep\%}/\code{\%except\%} are infix versions of these 
functions. \code{.keep}/\code{.except} are versions which works with 
\link{default_dataset}.
}
\examples{
keep(iris, "Sepal.Length", "Sepal.Width")  
keep(iris, qc(Sepal.Length, Sepal.Width)) # same result with non-standard eval 
except(iris, "Species")

keep(iris, "Species", other) # move 'Species' to the first position
keep(iris, to("Petal.Width")) # keep all columns except 'Species'

except(iris, perl("^Petal")) # remove columns which names starts with 'Petal'

keep(airquality, (from("Ozone") & to("Wind"))) # keep columns from 'Ozone' to 'Wind'

# the same examples with infix operators

iris \%keep\% c("Sepal.Length", "Sepal.Width") 
iris \%keep\% qc(Sepal.Length, Sepal.Width) # same result with non-standard eval
iris \%except\% "Species"

iris \%keep\% c("Species", other) # move 'Species' to the first position
iris \%keep\% to("Petal.Width")   # keep all columns except 'Species'

iris \%except\% perl("^Petal")    # remove columns which names starts with 'Petal'

airquality \%keep\% (from("Ozone") & to("Wind")) # keep columns from 'Ozone' to 'Wind'
    
}

