% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{val_lab}
\alias{add_val_lab}
\alias{add_val_lab<-}
\alias{make_labels}
\alias{ml_autonum}
\alias{ml_left}
\alias{ml_right}
\alias{set_val_lab}
\alias{unvl}
\alias{val_lab}
\alias{val_lab<-}
\title{Set or get value labels}
\usage{
val_lab(x)

val_lab(x) <- value

set_val_lab(x, value, add = FALSE)

add_val_lab(x, value)

add_val_lab(x) <- value

unvl(x)

make_labels(text, code_position = c("left", "right", "autonum"))

ml_left(text)

ml_right(text)

ml_autonum(text)
}
\arguments{
\item{x}{Variable(s). Vector/data.frame/list.}

\item{value}{Named vector. Names of vector are labels for the
appropriate values of variable x.}

\item{add}{Logical. Should we add value labels to old labels or replace it?
Deafult is FALSE - we completely replace old values. If TRUE new value
labels will be combined with old value labels.}

\item{text}{text that should be converted to named vector}

\item{code_position}{Possible values "left", "right" - position of numeric code in
\code{text}. "autonum" - makes codes by autonumbering lines of \code{text}.}
}
\value{
\code{val_lab} return value labels (named vector). If labels doesn't 
  exist it return NULL . \code{val_lab<-} and \code{set_val_lab} return 
  variable (vector x) of class "labelled" with attribute "labels" which
  contains value labels. \code{make_labels} return named vector for usage as
  value labels.
}
\description{
These functions set/get/drop value labels. Duplicated values are not allowed.
If argument \code{x} is data.frame or list then labels applied to all 
elements of data.frame/list. To drop value labels, use \code{val_lab(var) <- 
NULL} or \code{unvl(var)}. \code{make_labels} converts text from the form 
that usually used in questionnaires to named vector. See examples. For 
utilizing labels in base R see \link{f}, \link{names2labels}, 
\link{values2labels}, \link{unlab}, \link{dichotomy}. For variable labels see
\link{var_lab}.
\itemize{
\item{\code{val_lab}}{ returns value labels or NULL if labels doesn't 
exist.} 
\item{\code{val_lab<-}}{ set value labels.}
\item{\code{set_val_lab}}{ returns variable with value labels.} 
\item{\code{add_val_lab<-}}{ add value labels to already existing value labels.} 
\item{\code{unvl}}{ drops value labels.}
\item{\code{make_labels}}{ makes named vector from text for usage as value labels.}
\item{\code{ml_left}, \code{ml_right} and  \code{ml_autonum}}{ are shortcuts for \code{make_labels}
with \code{code_postion} 'left', 'right' and 'autonum' accordingly.}
}
}
\details{
Value labels are stored in attribute "labels" 
  (\code{attr(x,"labels")}). We set variable class to "labelled" for preserving
  labels from dropping during some operations (such as \code{c} and \code{`[`}).
  There are special methods of subsetting and concatenation for this class.
}
\examples{
# toy example
set.seed(123)
# score - evaluation of tested product

score = sample(-1:1,20,replace = TRUE)
var_lab(score) = "Evaluation of tested brand"
val_lab(score) = c("Dislike it" = -1,
                   "So-so" = 0,
                   "Like it" = 1    
                   )

# frequency of product scores                                      
fre(score)

# brands - multiple response question
# Which brands do you use during last three months? 

brands = t(replicate(20,sample(c(1:5,NA),4,replace = FALSE)))

var_lab(brands) = "Used brands"
val_lab(brands) = make_labels("
                              1 Brand A
                              2 Brand B
                              3 Brand C
                              4 Brand D
                              5 Brand E
                              ")


# percentage of used brands
fre(brands)

# percentage of brands within each score
cro(brands, score)


aggregate(dichotomy(brands) ~ f(score), FUN = mean)

# customer segmentation by used brands
kmeans(dichotomy(brands),3)

# model of influence of used brands on evaluation of tested product 
summary(lm(score ~ dichotomy(brands)))

## make labels from text copied from questionnaire

age = c(1, 2, 1, 2)

val_lab(age) = make_labels("
 1. 18 - 26
 2. 27 - 35
")

f(age)

# or, if in original codes is on the right side

products = 1:8

val_lab(products) = ml_right("
 Chocolate bars    1
 Chocolate sweets (bulk)	2
 Slab chocolate(packed)	3
 Slab chocolate (bulk)	4
 Boxed chocolate sweets	5
 Marshmallow/pastilles in chocolate coating	6
 Marmalade in chocolate coating	7
 Other	8
")

f(products)
}

