% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterbyoccpFAERS.R
\name{filterbyoccpFAERS}
\alias{filterbyoccpFAERS}
\alias{filter_by_occp_FAERS}
\title{Filter extracted FAERS data by reporter occupation}
\usage{
filter_by_occp_FAERS(
  workingdir = NULL,
  temp_dir = NULL,
  occpextract = NULL,
  savetoRData = FALSE
)
}
\arguments{
\item{workingdir}{Character vector. The directory containing decompressed FAERS ASCII folders.}

\item{temp_dir}{Internal parameter used only when \code{extract1PSFAERS} is called internally. Do not modify.}

\item{occpextract}{Character vector. Specifies the occupation types to extract.
Defaults to \code{c("MD", "HP", "PH", "OT")}.}

\item{savetoRData}{Logical. Determines whether to save \code{F_COREDATA_1PS_PROF.RData} in the working directory.
Must be set to \code{TRUE} if \code{filter_by_occu_FAERS} is used independently.}
}
\value{
A list containing six data frames, containing formatted FAERS data after selecting single-drug cases and filtering reports based on reporter occupation. Can be used by time_to_day_FAERS() to standardize time units.
}
\description{
Filter extracted FAERS data by reporter occupation
}
\details{
This package includes example data files in \code{extdata}:
\itemize{
\item \code{faers_ascii_2015q1_example.zip}: Example dataset 1.
\item \code{faers_ascii_2015q2_example.zip}: Example dataset 2.
\item \code{faers_ascii_2015q3_example.zip}: Example dataset 3.
\item \code{faers_ascii_2015q4_example.zip}: Example dataset 4.
\item Use \code{system.file("extdata",package = "extractFAERS")} to access the folder contain example zip files.
}
}
\examples{
# Example_1 Perform FAERS data preprocessing in one step and
# generate `F_COREDATA_1PS_PROF_STU.RData` in a temporary folder.
# In practice, it is recommended to set `usetempdir = FALSE` and specify `workingdir`
# to prevent the processed results in the temporary folder from being automatically deleted.
extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = FALSE,
  occpextract = NULL
)

# Example_2 Stepwise FAERS data preprocessing
# Setting `onlydoextract = TRUE` extracts only single-drug cases and organizes file paths.
# The processed file paths are saved in a temporary directory.
extractfaerspath <- extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = TRUE,
  occpextract = NULL
)
print(extractfaerspath)

# Filter data based on reporter occupation
# By default, only reports from healthcare professionals
# (e.g., physicians, pharmacists) are retained.
faers1psprofdata <- filter_by_occp_FAERS(
  workingdir = extractfaerspath,
  occpextract = NULL,
  savetoRData = TRUE
)

# Standardize time units to days
# This ensures consistency in the dataset and facilitates analysis of adverse reactions
# based on patient age.
time_to_day_FAERS(
workingdir = extractfaerspath,
usexistRData = TRUE,
filteres = NULL
)

}
