test_that("ran_pois", {
  expect_error(ran_pois(NA_integer_))
  expect_error(ran_pois(integer(0)))
  expect_identical(ran_pois(0L), integer(0))
  set.seed(101)
  expect_identical(ran_pois(), 1L)
  expect_identical(ran_pois(2), c(0L, 1L))
  expect_identical(ran_pois(2, 10), c(11L, 8L))
  expect_identical(ran_pois(2, c(0.1,100)), c(0L, 103L))
  expect_identical(ran_pois(1, c(0.1,100)), 0L)
})

test_that("ran_pois_zi", {
  expect_error(ran_pois_zi(NA_integer_))
  expect_error(ran_pois_zi(integer(0)))
  expect_identical(ran_pois_zi(0L), integer(0))
  set.seed(101)
  expect_identical(ran_pois_zi(), 1L)
  expect_identical(ran_pois_zi(2), c(0L, 1L))
  expect_identical(ran_pois_zi(2, 10), c(11L, 8L))
  expect_identical(ran_pois_zi(2, c(0.1,100)), c(0L, 103L))
  expect_identical(ran_pois_zi(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_pois_zi(10, 10, 0.5), c(0L, 11L, 7L, 8L, 0L, 0L, 0L, 10L, 0L, 0L))
})

test_that("ran_norm", {
  expect_error(ran_norm(NA_integer_))
  expect_error(ran_norm(integer(0)))
  expect_identical(ran_norm(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_norm(), -0.326036490515386)
  expect_equal(ran_norm(2), c(0.552461855419139, -0.67494384395583))
  expect_equal(ran_norm(2, 10), c(10.2143594590434, 10.3107692173136))
  expect_equal(ran_norm(2, c(0.1,100)), c(1.2739662875627, 100.618789855626))
  expect_equal(ran_norm(1, c(0.1,100)), -0.0127343147542145)
})

test_that("ran_lnorm", {
  expect_error(ran_lnorm(NA_integer_))
  expect_error(ran_lnorm(integer(0)))
  expect_identical(ran_lnorm(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_lnorm(), 0.721778848868975)
  expect_equal(ran_lnorm(2), c(1.73752529290614, 0.509185013620822))
  expect_equal(ran_lnorm(2, 10), c(27292.2882352846, 30054.546228237))
  expect_equal(ran_lnorm(2, c(0.1,100)), c(3.57500397331701, 4.99097288094876e+43))
  expect_equal(ran_lnorm(1, c(0.1,100)), 0.987346423552865)
})

test_that("ran_binom", {
  expect_error(ran_binom(NA_integer_))
  expect_error(ran_binom(integer(0)))
  expect_identical(ran_binom(0L), integer(0))
  set.seed(101)
  expect_identical(ran_binom(), 0L)
  expect_identical(ran_binom(2), c(0L, 1L))
  expect_identical(ran_binom(2, 10), c(6L, 4L))
  expect_identical(ran_binom(2, c(2,100)), c(1L, 47L))
  expect_identical(ran_binom(1, c(2,100)), 1L)
  expect_identical(ran_binom(1, 100, 0.1), 10L)
})

test_that("ran_bern", {
  expect_error(ran_bern(NA_integer_))
  expect_error(ran_bern(integer(0)))
  expect_identical(ran_bern(0L), integer(0))
  set.seed(101)
  expect_identical(ran_bern(), 0L)
  expect_identical(ran_bern(2), c(0L, 1L))
  expect_identical(ran_bern(2, c(0.1, 1)), c(0L, 1L))
  expect_identical(ran_bern(1, c(0.1, 1)), 0L)
})

test_that("ran_gamma_pois", {
  expect_error(ran_gamma_pois(NA_integer_))
  expect_error(ran_gamma_pois(integer(0)))
  expect_identical(ran_gamma_pois(0L), integer(0))
  set.seed(101)
  expect_identical(ran_gamma_pois(), 1L)
  expect_identical(ran_gamma_pois(2), c(0L, 2L))
  expect_identical(ran_gamma_pois(2, 10), c(14L, 7L))
  expect_identical(ran_gamma_pois(2, c(0.1,100)), c(0L, 108L))
  expect_identical(ran_gamma_pois(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_gamma_pois(theta = 10), 0L)
  expect_identical(ran_gamma_pois(2, theta = 10), c(1L, 2L))
  expect_identical(ran_gamma_pois(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_gamma_pois(2, 10, theta = 10), c(7L, 13L))
  expect_identical(ran_gamma_pois(2, c(0.1,100), theta = 1), c(0L, 12L))
  expect_identical(ran_gamma_pois(2, c(0.1,100), theta = 1), c(0L, 117L))
  expect_identical(ran_gamma_pois(1, c(0.1,100), theta = 1), 0L)
})

test_that("ran_neg_binom", {
  expect_error(ran_neg_binom(NA_integer_))
  expect_error(ran_neg_binom(integer(0)))
  expect_identical(ran_neg_binom(0L), integer(0))
  set.seed(101)
  expect_identical(ran_neg_binom(), 1L)
  expect_identical(ran_neg_binom(2), c(0L, 2L))
  expect_identical(ran_neg_binom(2, 10), c(14L, 7L))
  expect_identical(ran_neg_binom(2, c(0.1,100)), c(0L, 108L))
  expect_identical(ran_neg_binom(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_neg_binom(theta = 10), 0L)
  expect_identical(ran_neg_binom(2, theta = 10), c(1L, 2L))
  expect_identical(ran_neg_binom(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_neg_binom(2, 10, theta = 10), c(7L, 13L))
  expect_identical(ran_neg_binom(2, c(0.1,100), theta = 1), c(0L, 12L))
  expect_identical(ran_neg_binom(2, c(0.1,100), theta = 1), c(0L, 117L))
  expect_identical(ran_neg_binom(1, c(0.1,100), theta = 1), 0L)
})
