% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_blocks.R
\name{bktt}
\alias{bktt}
\title{Block transpose matrix with transposed blocks}
\usage{
bktt(df)
}
\arguments{
\item{df}{A square block matrix with named rows and columns.
Names of countries and sectors are automatically identified. Unlike
\code{\link[=bkt]{bkt()}}, \code{bktt()} can only be used with square block
matrices with \code{NxN} blocks (with row and column names in the form
\code{AUS_01T02}, \code{AUS_05}, etc.)}
}
\value{
Block transposed version of \code{df} with elements transposed.
}
\description{
Block transpose matrix and then transpose each block. \code{block(s,r)} is
transformed into \code{block(r,s)} and then internally transposed. This is not
equivalent to directly transpose the matrix.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
# Block-transpose Z and transpose blocks (show first elements only)
bktt(wio$Z)[1:6, 1:6]
# Note that directly transposing Z produces a different result:
t(wio$Z)[1:6, 1:6]
}
\seealso{
\code{\link[=bkt]{bkt()}}.
}
