% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_mult.R
\name{dmult}
\alias{dmult}
\title{Multiply a diagonal matrix by another matrix}
\usage{
dmult(matrix1, matrix2)
}
\arguments{
\item{matrix1}{A diagonal matrix.}

\item{matrix2}{An ordinary matrix.}
}
\value{
Product of matrix1 and matrix2.
}
\description{
Fast multiplication of a diagonal matrix by another matrix, taking
taking advantage of the properties of diagonal matrices.
}
\details{
\code{dmult()} will turn \code{matrix1} into a vector and multiply it
horizontally by every rows in \code{matrix2}. This saves precious computing
time.\
The number of rows and columns of the diagonal \code{matrix1} must be
equal to the number of rows of \code{matrix1}.
}
\examples{
wio <- make_wio("wiodtest")
dmult(wio$W, wio$Bd)
}
\seealso{
\code{\link[=multd]{multd()}}.
}
