% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyes.R
\name{eyes}
\alias{eyes}
\alias{eyestr}
\title{Count patients and eyes}
\usage{
eyes(x, id = NULL, eye = NULL, dropunknown = TRUE)

eyestr(x, ..., small_num = TRUE, para = FALSE, UK = FALSE)
}
\arguments{
\item{x}{required. (data frame)}

\item{id}{Patient identifying column, passed as (quoted) character}

\item{eye}{Eye identifying column, passed as (quoted) character}

\item{dropunknown}{introduces NA for values not recognized by \link{recodeye}}

\item{...}{passed to \link{eyes}}

\item{small_num}{If TRUE: writing numbers <= 12 as words}

\item{para}{If TRUE: Adding "A total of" to comply with most
journal standards and to avoid awkward long numbers.}

\item{UK}{Logical, Use UK (English) style (TRUE) or
USA (American) style (FALSE).}
}
\value{
\code{eyes}: Named integer vector with count of patients and eyes

\code{eyestr}: Character string - can be directly pasted into reports
}
\description{
Counts number of patients and right and left eyes. Columns are
guessed.
}
\section{Guessing}{

\strong{id} and \strong{eye} arguments overrule the name guessing for
the respective columns (here, cases need to match)

For any below, \strong{cases are always ignored} (column names can be in upper or
lower case, as you please)

\strong{patient ID columns}:
\itemize{
\item First, \code{eyes} is looking for names that contain both strings
"pat" and "id" (the order doesn't matter)
\item Next, it will look for columns that are plainly called "ID"
\item Last, it will search for all names that contain either "pat"
or "id"
}

\strong{eye variable column}:
\itemize{
\item \code{eyes} primarily looks for columns called either "eye" or "eyes",
and if they are not present, columns containing string "eye"
(e.g., EyeName will be recognized)
}
}

\section{Eye coding}{

The following codes are recognized:
\itemize{
\item integer coding 0:1 and 1:2, right eye being the lower number.
\item right eyes: c("r", "re", "od", "right") and
\item left eyes: c("l", "le", "os", "left") and
\item both eyes: c("b", "both", "ou")
}

If your eye column contains other values, they will be dropped to
NA (dropunknown) or kept (and then only patients will be counted, because
coding remains unclear). Recommend then to recode with \link{recodeye}
}

\section{eyestr}{

eyestr is a wrapper around eyes. It parses the result into meaningful text,
which can be #'  readily pasted into reports with \link{eyes_to_string} under the hood.
Arguments to \code{eyes_to_string} are passed via \strong{...}:
\itemize{
\item \strong{small_num} If TRUE (default): numbers <= 12 as words
\item \strong{para} If TRUE (not default): Adding "A total of" to
comply with most journal standards and to avoid awkward
long numbers.
\item \strong{UK} TRUE: UK style (English) or FALSE (default):
US style (American).
}
}

\examples{
library(eyedata)
eyes(amd2)
library(eyedata)
eyestr(amd2, para = TRUE)
}
\concept{eye core functions}
