% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-deblink.R
\name{deblink}
\alias{deblink}
\title{NA-pad blink events / missing data}
\usage{
deblink(eyeris, extend = 40)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} dervived from \code{\link[=load]{load()}}.}

\item{extend}{Either a single number indicating the number of milliseconds to
pad forward/backward around each missing sample, or, a vector of length two
indicating different numbers of milliseconds pad forward/backward around each
missing sample, in the format \code{c(backward, forward)}.}
}
\value{
An \code{eyeris} object with a new column: \verb{pupil_raw_\{...\}_deblink}.
}
\description{
Deblinking (a.k.a. NA-padding) of time series data. The intended use of
this method is to remove blink-related artifacts surrounding periods of
missing data. For instance, when an individual blinks, there are usually
rapid decreases followed by increases in pupil size, with a chunk of data
missing in-between these 'spike'-looking events. The deblinking procedure
here will NA-pad each missing data point by your specified number of ms.
}
\details{
This function is automatically called by \code{glassbox()} by default. If needed,
customize the parameters for \code{deblink} by providing a parameter list. Use
\code{glassbox(deblink = FALSE)} to disable this step as needed.

Users should prefer using \code{glassbox()} rather than invoking this function
directly unless they have a specific reason to customize the pipeline
manually.
}
\note{
This function is part of the \code{glassbox()} preprocessing pipeline and is not
intended for direct use in most cases. Provide parameters via
\code{deblink = list(...)}.

Advanced users may call it directly if needed.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

# 50 ms in both directions
demo_data |>
  eyeris::glassbox(deblink = list(extend = 50)) |>
  plot(seed = 0)

# 40 ms backward, 50 ms forward
demo_data |>
  # set deblink to FALSE (instead of a list of params)
  #  to skip step (not recommended)
  eyeris::glassbox(deblink = list(extend = c(40, 50))) |>
  plot(seed = 0)

}
\seealso{
\code{\link[=glassbox]{glassbox()}} for the recommended way to run this step as
part of the full eyeris glassbox preprocessing pipeline.
}
