% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-confounds.R
\name{export_confounds_to_csv}
\alias{export_confounds_to_csv}
\title{Export confounds data to CSV files}
\usage{
export_confounds_to_csv(
  confounds_list,
  output_dir,
  filename_prefix,
  verbose,
  run_num = NULL
)
}
\arguments{
\item{confounds_list}{A nested list structure containing confounds data}

\item{output_dir}{The directory where CSV files will be saved}

\item{filename_prefix}{Either a string prefix for filenames or a function
that takes a block name and returns a prefix}

\item{verbose}{A flag to indicate whether to print progress messages}

\item{run_num}{The run number}
}
\value{
Invisibly returns a vector of created file paths
}
\description{
Exports each block's confounds data to a separate CSV file.
Each file will contain all pupil steps (e.g., pupil_raw, pupil_clean)
as rows, with confound metrics as columns.
}
\keyword{internal}
