% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\name{eyeris_color_palette}
\alias{eyeris_color_palette}
\title{Default color palette for eyeris plotting functions}
\usage{
eyeris_color_palette()
}
\value{
A character vector of 7 hex color codes representing the default
eyeris color palette
}
\description{
A custom color palette designed for visualizing pupil data
preprocessing steps. This palette is based on the RColorBrewer Set1 palette
and provides distinct, visually appealing colors for different preprocessing
stages.
}
\details{
The palette includes 7 colors optimized for:
\itemize{
\item High contrast and visibility
\item Colorblind-friendly design
\item Consistent visual hierarchy across preprocessing steps
\item Professional appearance in reports and publications
}

Colors are designed to work well with both light and dark backgrounds
and maintain readability when overlaid in time series plots.
}
\examples{
# get the default color palette
colors <- eyeris_color_palette()
print(colors)

# use in a plot
plot(1:7, 1:7, col = colors, pch = 19, cex = 3)

}
