% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure-distribution.R
\name{measure_distribution_over_time}
\alias{measure_distribution_over_time}
\title{Plot the change of distribution of a numeric (measure) column over time}
\usage{
measure_distribution_over_time(data, measure, time, bwidth = NULL)
}
\arguments{
\item{data}{A data frame or tibble}

\item{measure}{Unquoted column name of containing numbers (measure)}

\item{time}{Unquoted name of column containing the time object}

\item{bwidth}{width of bin for histogram (by default uses binwidth for 30 bins)}
}
\value{
A ggplot plot object
}
\description{
Plot the change of distribution of a numeric (measure) column over time
}
\examples{
h1 <- round(rnorm(50, 60, 8), 0)
h2 <- round(rnorm(50, 65, 8), 0)
h3 <- round(rnorm(50, 70, 8), 0)
h <- c(h1, h2, h3)
y <- c(rep(1999, 50), rep(2000, 50), rep(2001, 50))
df <- data.frame(height = h, year = y)
measure_distribution_over_time(df, h, year)
}
