% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{sdvar}
\alias{sdvar}
\alias{sd}
\alias{sd.default}
\alias{sd.dfts}
\alias{var}
\alias{var.default}
\alias{var.dfts}
\title{Generic Function for Variance and Standard Deviation Computation}
\usage{
sd(object, ...)

\method{sd}{default}(object, ...)

\method{sd}{dfts}(object, type = "pointwise", ...)

var(object, ...)

\method{var}{default}(object, ...)

\method{var}{dfts}(object, type = c("operator", "pointwise"), ...)
}
\arguments{
\item{object}{Object for computation of standard deviation or variance of
the given data set.}

\item{...}{Additional parameters for the particular extensions.}

\item{type}{String to specify if an operator ('op') or pointwise ('pw')
calculation is desired on the functional data.}
}
\value{
Numeric(s) to explain the standard deviation / variance
}
\description{
Generic function to compute the variance and standard deviations. The default
uses \code{\link[stats:cor]{stats::var()}} and \code{\link[stats:sd]{stats::sd()}}.
}
\examples{
sd(1:10)
var(1:10)
sd(electricity,type='pointwise')
var(electricity,type='pointwise')
var(electricity,type='operator')
}
\seealso{
\code{\link[stats:sd]{stats::sd()}}, \code{\link[stats:cor]{stats::var()}}
}
